/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.client.tooltip.component.DogTagImageComponent;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.menu.DogTagEditorMenu;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class DogTag
extends Item
implements ICurioItem {
    public DogTag() {
        super(new Item.Properties().stacksTo(1));
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        AtomicBoolean flag = new AtomicBoolean(true);
        CuriosApi.getCuriosInventory((LivingEntity)livingEntity).flatMap(c -> c.findFirstCurio((Item)this)).ifPresent(s -> flag.set(false));
        return flag.get();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, p) -> new DogTagEditorMenu(i, ContainerLevelAccess.create((Level)level, (BlockPos)p.getOnPos()), stack), (Component)Component.empty()));
        return InteractionResultHolder.consume((Object)stack);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new DogTagImageComponent(pStack));
    }

    public static short[][] getColors(ItemStack stack) {
        short[][] colors;
        for (short[] el : colors = new short[16][16]) {
            Arrays.fill(el, (short)-1);
        }
        List data = (List)stack.get(ModDataComponents.DOG_TAG_IMAGE);
        if (data == null) {
            return colors;
        }
        int index = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                colors[i][j] = (Short)data.get(index);
                ++index;
            }
        }
        return colors;
    }
}

