/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.component.ModDataComponents;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FiringParameters
extends Item {
    public FiringParameters() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        Player player = pContext.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        pos = pos.relative(pContext.getClickedFace());
        Parameters parameters = (Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS);
        boolean isDepressed = parameters != null && parameters.isDepressed();
        stack.set(ModDataComponents.FIRING_PARAMETERS, (Object)new Parameters(pos, isDepressed));
        return InteractionResult.SUCCESS;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!player.isCrouching()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        ItemStack stack = player.getItemInHand(usedHand);
        Parameters parameters = (Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS);
        if (parameters == null) {
            return InteractionResultHolder.fail((Object)stack);
        }
        boolean isDepressed = !parameters.isDepressed();
        stack.set(ModDataComponents.FIRING_PARAMETERS, (Object)new Parameters(parameters.pos(), isDepressed));
        player.displayClientMessage((Component)Component.translatable((String)(isDepressed ? "tips.superbwarfare.mortar.target_pos.depressed_trajectory" : "tips.superbwarfare.mortar.target_pos.lofted_trajectory")).withStyle(ChatFormatting.GREEN), true);
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Parameters parameters = (Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS);
        if (parameters == null) {
            return;
        }
        BlockPos pos = parameters.pos();
        tooltipComponents.add((Component)Component.translatable((String)"tips.superbwarfare.mortar.target_pos").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)("[" + pos.getX() + "," + pos.getY() + "," + pos.getZ() + "]"))));
        tooltipComponents.add((Component)Component.translatable((String)(parameters.isDepressed ? "tips.superbwarfare.mortar.target_pos.depressed_trajectory" : "tips.superbwarfare.mortar.target_pos.lofted_trajectory")).withStyle(ChatFormatting.GRAY));
    }

    public record Parameters(BlockPos pos, boolean isDepressed) {
    }
}

