/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Transcript
extends Item {
    public Transcript() {
        super(new Item.Properties().stacksTo(1));
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.transcript").withStyle(ChatFormatting.GRAY));
        this.addScoresText(stack, tooltipComponents);
    }

    public void addScoresText(ItemStack stack, List<Component> tooltip) {
        List<Pair> scores = (List<Pair>)stack.get(ModDataComponents.TRANSCRIPT_SCORE);
        if (scores == null) {
            scores = List.of();
        }
        int total = 0;
        for (Pair info : scores) {
            int score = (Integer)info.getFirst();
            total += score;
            tooltip.add((Component)Component.translatable((String)"des.superbwarfare.transcript.score").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(score + " ")).withStyle(score == 10 ? ChatFormatting.GOLD : ChatFormatting.WHITE)).append((Component)Component.translatable((String)"des.superbwarfare.transcript.distance").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)FormatTool.format1D((Double)info.getSecond(), "m")).withStyle(ChatFormatting.WHITE)));
        }
        tooltip.add((Component)Component.translatable((String)"des.superbwarfare.transcript.total").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)(total + " ")).withStyle(total == 100 ? ChatFormatting.GOLD : ChatFormatting.WHITE)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pPlayer.isCrouching()) {
            ItemStack stack = pPlayer.getItemInHand(pUsedHand);
            stack.set(ModDataComponents.TRANSCRIPT_SCORE, List.of());
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }
}

