/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.client.PoseTool;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.data.gun.subdata.Attachment;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.data.launchable.LaunchableEntityTool;
import com.atsuishio.superbwarfare.data.launchable.ShootData;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.CustomRendererItem;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

@EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
public abstract class GunItem
extends Item
implements CustomRendererItem,
GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final ResourceLocation SPEED_ID = Mod.loc("gun_movement_speed");
    public final Map<Integer, Consumer<GunData>> reloadTimeBehaviors = new HashMap<Integer, Consumer<GunData>>();

    public GunItem(Item.Properties properties) {
        super(properties);
        this.addReloadTimeBehavior(this.reloadTimeBehaviors);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        GunData data = GunData.from(stack);
        return data.heat.get() != 0.0;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        GunData data = GunData.from(stack);
        return Math.round((float)data.heat.get() * 13.0f / 100.0f);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        GunData data = GunData.from(stack);
        double f = 1.0 - data.heat.get() / 100.0;
        return Mth.hsvToRgb((float)((float)f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean canAttackBlock(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        GunData data;
        Item item;
        LivingEntity living;
        block16: {
            block15: {
                if (!(entity instanceof LivingEntity)) break block15;
                living = (LivingEntity)entity;
                item = stack.getItem();
                if (item instanceof GunItem) break block16;
            }
            return;
        }
        GunItem gunItem = (GunItem)item;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel);
        }
        if (!(data = GunData.from(stack)).initialized()) {
            Player player;
            data.initialize();
            if (level.getServer() != null && entity instanceof Player && (player = (Player)entity).isCreative()) {
                data.ammo.set(data.magazine());
            }
        }
        data.draw.set(false);
        for (Player type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance((Perk.Type)type);
            if (instance == null) continue;
            instance.perk().tick(data, instance, living);
        }
        boolean hasBulletInBarrel = gunItem.hasBulletInBarrel(stack);
        int ammoCount = data.ammo.get();
        int magazine = data.magazine();
        if (hasBulletInBarrel && ammoCount > magazine + 1 || !hasBulletInBarrel && ammoCount > magazine) {
            int count = ammoCount - magazine - (hasBulletInBarrel ? 1 : 0);
            PlayerVariable capability = ((PlayerVariable)entity.getData(ModAttachments.PLAYER_VARIABLE)).watch();
            Ammo ammoType = data.ammoTypeInfo().playerAmmoType();
            if (ammoType != null) {
                ammoType.add(capability, count);
            }
            entity.setData(ModAttachments.PLAYER_VARIABLE, (Object)capability);
            capability.sync(entity);
            data.ammo.set(magazine + (hasBulletInBarrel ? 1 : 0));
        }
        double cooldown = 0.0;
        if (entity.wasInPowderSnow) {
            cooldown = 0.15;
        } else if (entity.isInWaterOrRain()) {
            cooldown = 0.04;
        } else if (entity.isOnFire() || entity.isInLava()) {
            cooldown = -0.1;
        }
        data.heat.set(Mth.clamp((double)(data.heat.get() - 0.25 - cooldown), (double)0.0, (double)100.0));
        if (data.heat.get() < 80.0 && data.overHeat.get()) {
            data.overHeat.set(false);
        }
        data.save();
    }

    @ParametersAreNonnullByDefault
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        ArrayList<ItemAttributeModifiers.Entry> list = new ArrayList<ItemAttributeModifiers.Entry>(super.getDefaultAttributeModifiers(stack).modifiers());
        GunData data = GunData.from(stack);
        list.add(new ItemAttributeModifiers.Entry(Attributes.MOVEMENT_SPEED, new AttributeModifier(SPEED_ID, (double)-0.01f - (double)0.005f * data.weight(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND));
        if (data.meleeDamage() > 0.0) {
            list.add(new ItemAttributeModifiers.Entry(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, data.meleeDamage(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
        }
        return new ItemAttributeModifiers(list, true);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new GunImageComponent(pStack));
    }

    public Set<SoundEvent> getReloadSound() {
        return Set.of();
    }

    public ResourceLocation getGunIcon() {
        return Mod.loc("textures/gun_icon/default_icon.png");
    }

    public String getGunDisplayName() {
        return "";
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public boolean isOpenBolt(ItemStack stack) {
        return false;
    }

    public boolean hasBulletInBarrel(ItemStack stack) {
        return false;
    }

    public boolean isCustomizable(ItemStack stack) {
        return false;
    }

    public boolean hasCustomBarrel(ItemStack stack) {
        return false;
    }

    public boolean hasCustomGrip(ItemStack stack) {
        return false;
    }

    public boolean hasCustomMagazine(ItemStack stack) {
        return false;
    }

    public boolean hasCustomScope(ItemStack stack) {
        return false;
    }

    public boolean hasCustomStock(ItemStack stack) {
        return false;
    }

    public boolean hasBipod(ItemStack stack) {
        return false;
    }

    public boolean canEjectShell(ItemStack stack) {
        return false;
    }

    public boolean hasMeleeAttack(ItemStack stack) {
        return GunData.from(stack).meleeDamage() > 0.0;
    }

    public double getCustomDamage(ItemStack stack) {
        return 0.0;
    }

    public double getCustomHeadshot(ItemStack stack) {
        return 0.0;
    }

    public double getCustomBypassArmor(ItemStack stack) {
        return 0.0;
    }

    public int getCustomMagazine(ItemStack stack) {
        return 0;
    }

    public double getCustomZoom(ItemStack stack) {
        return 0.0;
    }

    public int getCustomRPM(ItemStack stack) {
        return 0;
    }

    public double getCustomWeight(ItemStack stack) {
        Attachment attachment = GunData.from((ItemStack)stack).attachment;
        double scopeWeight = switch (attachment.get(AttachmentType.SCOPE)) {
            case 1 -> 0.5;
            case 2 -> 1.0;
            case 3 -> 1.5;
            default -> 0.0;
        };
        double barrelWeight = switch (attachment.get(AttachmentType.BARREL)) {
            case 1 -> 0.5;
            case 2 -> 1.0;
            default -> 0.0;
        };
        double magazineWeight = switch (attachment.get(AttachmentType.MAGAZINE)) {
            case 1 -> 1.0;
            case 2 -> 2.0;
            default -> 0.0;
        };
        double stockWeight = switch (attachment.get(AttachmentType.STOCK)) {
            case 1 -> -2.0;
            case 2 -> 1.5;
            default -> 0.0;
        };
        double gripWeight = switch (attachment.get(AttachmentType.GRIP)) {
            case 1, 2 -> 0.25;
            case 3 -> 1.0;
            default -> 0.0;
        };
        return scopeWeight + barrelWeight + magazineWeight + stockWeight + gripWeight;
    }

    public double getCustomVelocity(ItemStack stack) {
        return 0.0;
    }

    public double getCustomSoundRadius(ItemStack stack) {
        return GunData.from((ItemStack)stack).attachment.get(AttachmentType.BARREL) == 2 ? 0.6 : 1.0;
    }

    public int getCustomBoltActionTime(ItemStack stack) {
        return 0;
    }

    public boolean canAdjustZoom(ItemStack stack) {
        return false;
    }

    public boolean canSwitchScope(ItemStack stack) {
        return false;
    }

    public String getAmmoDisplayName(GunData data) {
        Ammo type = data.ammoTypeInfo().playerAmmoType();
        if (type != null) {
            return type.displayName;
        }
        return "";
    }

    public void addReloadTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
    }

    public boolean canShoot(GunData data) {
        return data.projectileAmount() > 0;
    }

    public void beforeShoot(GunData data, Player player, double spread, boolean zoom) {
        if (data.ammo.get() == 1) {
            data.holdOpen.set(true);
        }
        if (data.defaultActionTime() > 0 && data.ammo.get() > 1) {
            data.bolt.needed.set(true);
        }
    }

    public void afterShoot(GunData data, Player player) {
        if (!data.useBackpackAmmo()) {
            data.ammo.set(data.ammo.get() - 1);
            data.isEmpty.set(true);
        } else {
            data.consumeBackupAmmo(player, 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onShoot(GunData data, Player player, double spread, boolean zoom) {
        if (!data.hasEnoughAmmoToShoot(player)) {
            return;
        }
        data.item.beforeShoot(data, player, spread, zoom);
        projectileAmount = data.projectileAmount();
        perk = data.perk.get(Perk.Type.AMMO);
        index0 = 0;
        while (true) {
            if (!(perk instanceof AmmoPerk)) ** GOTO lbl-1000
            ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                v0 = 1;
            } else lbl-1000:
            // 2 sources

            {
                v0 = projectileAmount;
            }
            if (index0 >= v0) break;
            if (!this.shootBullet(player, data, spread, zoom)) {
                return;
            }
            ++index0;
        }
        data.heat.set(Mth.clamp((double)(data.heat.get() + data.heatPerShoot()), (double)0.0, (double)100.0));
        if (data.heat.get() >= 100.0 && !data.overHeat.get()) {
            data.overHeat.set(true);
            if (!player.level().isClientSide() && player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.MINIGUN_OVERHEAT.get(), 2.0f, 1.0f);
            }
        }
        data.item.afterShoot(data, player);
        this.playFireSounds(data, player, zoom);
    }

    public void playFireSounds(GunData data, Player player, boolean zoom) {
        SoundEvent soundVeryFar;
        SoundEvent soundFar;
        ItemStack stack = data.stack;
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        String origin = stack.getItem().getDescriptionId();
        String name = origin.substring(origin.lastIndexOf(".") + 1);
        float pitch = data.heat.get() <= 75.0 ? 1.0f : (float)(1.0 - 0.02 * Math.abs(75.0 - data.heat.get()));
        Perk perk = data.perk.get(Perk.Type.AMMO);
        if (perk == ModPerks.BEAST_BULLET.get()) {
            player.playSound((SoundEvent)ModSounds.HENG.get(), 4.0f, pitch);
        }
        float soundRadius = (float)data.soundRadius();
        int barrelType = data.attachment.get(AttachmentType.BARREL);
        SoundEvent sound3p = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc(name + (barrelType == 2 ? "_fire_3p_s" : "_fire_3p")));
        if (sound3p != null) {
            player.playSound(sound3p, soundRadius * 0.4f, pitch);
        }
        if ((soundFar = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc(name + (barrelType == 2 ? "_far_s" : "_far")))) != null) {
            player.playSound(soundFar, soundRadius * 0.7f, pitch);
        }
        if ((soundVeryFar = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc(name + (barrelType == 2 ? "_veryfar_s" : "_veryfar")))) != null) {
            player.playSound(soundVeryFar, soundRadius, pitch);
        }
    }

    public void onFireKeyPress(GunData data, Player player, boolean zoom) {
        if (data.reload.prepareTimer.get() == 0 && data.reloading() && data.hasEnoughAmmoToShoot(player)) {
            data.forceStop.set(true);
        }
    }

    public void onFireKeyRelease(GunData data, Player player, double power, boolean zoom) {
    }

    public static double perkDamage(Perk perk) {
        if (perk instanceof AmmoPerk) {
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            return ammoPerk.damageRate;
        }
        return 1.0;
    }

    public boolean shootBullet(Player player, GunData data, double spread, boolean zoom) {
        ItemStack stack = data.stack;
        Level level = player.level();
        float headshot = (float)data.headshot();
        float damage = (float)data.damage();
        float velocity = (float)data.velocity();
        float bypassArmorRate = (float)data.bypassArmor();
        String projectileType = data.projectileType();
        ProjectileInfo projectileInfo = data.projectileInfo();
        AtomicReference entityHolder = new AtomicReference();
        EntityType.byString((String)projectileType).ifPresent(entityType -> {
            Entity entity = entityType.create(level);
            if (entity == null) {
                return;
            }
            if (entity instanceof Projectile) {
                Projectile projectileEntity = (Projectile)entity;
                projectileEntity.setOwner((Entity)player);
            }
            if (entity instanceof ProjectileEntity) {
                ProjectileEntity projectile = (ProjectileEntity)entity;
                projectile.shooter((LivingEntity)player).damage(damage).headShot(headshot).zoom(zoom).bypassArmorRate(bypassArmorRate).setGunItemId(stack);
            }
            if (entity instanceof ExplosiveProjectile) {
                ExplosiveProjectile explosive = (ExplosiveProjectile)entity;
                explosive.setDamage(damage);
                explosive.setExplosionDamage((float)data.explosionDamage());
                explosive.setExplosionRadius((float)data.explosionRadius());
            }
            if (projectileInfo.data != null) {
                CompoundTag tag = LaunchableEntityTool.getModifiedTag(projectileInfo, new ShootData(player.getUUID(), damage, data.explosionDamage(), data.explosionRadius(), data.spread()));
                if (tag != null) {
                    entity.load(tag);
                }
            } else if (LaunchableEntityTool.launchableEntitiesData.containsKey(projectileType)) {
                ProjectileInfo newInfo = new ProjectileInfo();
                newInfo.data = LaunchableEntityTool.launchableEntitiesData.get(projectileType);
                newInfo.type = projectileType;
                CompoundTag tag = LaunchableEntityTool.getModifiedTag(newInfo, new ShootData(player.getUUID(), damage, data.explosionDamage(), data.explosionRadius(), data.spread()));
                if (tag != null) {
                    entity.load(tag);
                }
            }
            entityHolder.set(entity);
        });
        Entity entity = (Entity)entityHolder.get();
        if (entity == null) {
            return false;
        }
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().modifyProjectile(data, instance, entity);
            Perk perk = instance.perk();
            if (!(perk instanceof AmmoPerk)) continue;
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            velocity = (float)ammoPerk.getModifiedVelocity(data, instance);
        }
        entity.setPos(player.getX() - 0.1 * player.getLookAngle().x, player.getEyeY() - 0.1 - 0.1 * player.getLookAngle().y, player.getZ() + -0.1 * player.getLookAngle().z);
        double x = player.getLookAngle().x;
        double y = player.getLookAngle().y + (double)0.001f;
        double z = player.getLookAngle().z;
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            projectile.shoot(x, y, z, velocity, (float)spread);
        } else {
            Vec3 vec3 = new Vec3(x, y, z).normalize().add(entity.getRandom().triangle(0.0, 0.0172275 * spread), entity.getRandom().triangle(0.0, 0.0172275 * spread), entity.getRandom().triangle(0.0, 0.0172275 * spread)).scale((double)velocity);
            entity.setDeltaMovement(vec3);
            entity.hasImpulse = true;
            double d0 = vec3.horizontalDistance();
            entity.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
            entity.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 180.0 / 3.1415927410125732));
            entity.yRotO = entity.getYRot();
            entity.xRotO = entity.getXRot();
        }
        level.addFreshEntity(entity);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack stack) {
        return PoseTool.pose(entityLiving, hand, stack);
    }

    @SubscribeEvent
    private static void registerGunExtensions(RegisterClientExtensionsEvent event) {
        for (DeferredHolder item : ModItems.GUNS.getEntries()) {
            Object object = item.get();
            if (!(object instanceof GunItem)) continue;
            final GunItem gun = (GunItem)object;
            event.registerItem(new IClientItemExtensions(){
                private final BlockEntityWithoutLevelRenderer renderer;
                {
                    this.renderer = (BlockEntityWithoutLevelRenderer)gun.getRenderer().get();
                }

                @NotNull
                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return this.renderer;
                }

                @ParametersAreNonnullByDefault
                public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack stack) {
                    return gun.getArmPose(entityLiving, hand, stack);
                }
            }, new Holder[]{item});
        }
    }
}

