/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.handgun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.gun.Mp443ItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class Mp443Item
extends GunItem {
    public Mp443Item() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON));
    }

    @Override
    public Supplier<GeoItemRenderer<? extends Item>> getRenderer() {
        return Mp443ItemRenderer::new;
    }

    private PlayState fireAnimPredicate(AnimationState<Mp443Item> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mp_443.idle"));
        }
        if (GunData.from((ItemStack)stack).reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mp_443.reload_empty"));
        }
        if (GunData.from((ItemStack)stack).reload.normal()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mp_443.reload_normal"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mp_443.idle"));
    }

    private PlayState idlePredicate(AnimationState<Mp443Item> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mp_443.idle"));
        }
        if (player.isSprinting() && player.onGround() && ClientEventHandler.cantSprint == 0.0f && !GunData.from((ItemStack)stack).reload.normal() && !GunData.from((ItemStack)stack).reload.empty() && ClientEventHandler.drawTime < 0.01) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mp_443.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mp_443.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mp_443.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController fireAnimController = new AnimationController((GeoAnimatable)this, "fireAnimController", 1, this::fireAnimPredicate);
        data.add(fireAnimController);
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 2, this::idlePredicate);
        data.add(idleController);
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.MP_443_RELOAD_EMPTY.get(), (SoundEvent)ModSounds.MP_443_RELOAD_NORMAL.get());
    }

    @Override
    public ResourceLocation getGunIcon() {
        return Mod.loc("textures/gun_icon/mp_443_icon.png");
    }

    @Override
    public String getGunDisplayName() {
        return "MP-443";
    }

    @Override
    public boolean isOpenBolt(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasBulletInBarrel(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canEjectShell(ItemStack stack) {
        return true;
    }

    @Override
    public void addReloadTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
        super.addReloadTimeBehavior(behaviors);
        behaviors.put(9, data -> data.holdOpen.set(false));
    }
}

