/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.launcher;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.client.renderer.gun.SecondaryCataclysmRenderer;
import com.atsuishio.superbwarfare.client.tooltip.component.SecondaryCataclysmImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.GunGrenadeEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModEnumExtensions;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.EnergyStorageItem;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class SecondaryCataclysm
extends GunItem
implements EnergyStorageItem {
    public SecondaryCataclysm() {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(ModEnumExtensions.getLegendary()));
    }

    @Override
    public boolean isBarVisible(@NotNull ItemStack stack) {
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return cap != null && cap.getEnergyStored() > 0;
    }

    @Override
    public int getBarWidth(@NotNull ItemStack stack) {
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return Math.round((float)(cap != null ? cap.getEnergyStored() : 0) * 13.0f / 24000.0f);
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.empty());
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.secondary_cataclysm_1").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        TooltipTool.addHideText(tooltipComponents, (Component)Component.empty());
        TooltipTool.addHideText(tooltipComponents, (Component)Component.translatable((String)"des.superbwarfare.trachelium_3").withStyle(ChatFormatting.WHITE));
        TooltipTool.addHideText(tooltipComponents, (Component)Component.translatable((String)"des.superbwarfare.secondary_cataclysm_2").withStyle(Style.EMPTY.withColor(6863350)));
    }

    @Override
    public int getBarColor(@NotNull ItemStack pStack) {
        return 9824767;
    }

    @Override
    public Supplier<GeoItemRenderer<? extends Item>> getRenderer() {
        return SecondaryCataclysmRenderer::new;
    }

    private PlayState reloadAnimPredicate(AnimationState<SecondaryCataclysm> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.idle"));
        }
        GunData data = GunData.from(stack);
        if (data.reload.stage() == 1 && data.reload.prepareLoadTimer.get() > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.secondary_cataclysm.prepare"));
        }
        if (data.loadIndex.get() == 0 && data.reload.stage() == 2) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.secondary_cataclysm.iterativeload"));
        }
        if (data.loadIndex.get() == 1 && data.reload.stage() == 2) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.secondary_cataclysm.iterativeload2"));
        }
        if (data.reload.stage() == 3) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.secondary_cataclysm.finish"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.idle"));
    }

    private PlayState idlePredicate(AnimationState<SecondaryCataclysm> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.idle"));
        }
        GunData data = GunData.from(stack);
        if (player.isSprinting() && player.onGround() && ClientEventHandler.cantSprint == 0.0f && !data.reload.empty() && data.reload.stage() != 1 && data.reload.stage() != 2 && data.reload.stage() != 3 && ClientEventHandler.drawTime < 0.01 && ClientEventHandler.gunMelee == 0 && !data.reloading()) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.idle"));
    }

    private PlayState meleePredicate(AnimationState<SecondaryCataclysm> event) {
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.idle"));
        }
        if (ClientEventHandler.gunMelee > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.secondary_cataclysm.hit"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.secondary_cataclysm.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController reloadAnimController = new AnimationController((GeoAnimatable)this, "reloadAnimController", 1, this::reloadAnimPredicate);
        data.add(reloadAnimController);
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 3, this::idlePredicate);
        data.add(idleController);
        AnimationController meleeController = new AnimationController((GeoAnimatable)this, "meleeController", 0, this::meleePredicate);
        data.add(meleeController);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack cell : player.getInventory().items) {
                IEnergyStorage stackStorage;
                if (!cell.is((Item)ModItems.CELL.get()) || (stackStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null) continue;
                int stackMaxEnergy = stackStorage.getMaxEnergyStored();
                int stackEnergy = stackStorage.getEnergyStored();
                IEnergyStorage cellStorage = (IEnergyStorage)cell.getCapability(Capabilities.EnergyStorage.ITEM);
                if (cellStorage == null) continue;
                int cellEnergy = cellStorage.getEnergyStored();
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0) {
                    stackStorage.receiveEnergy(stackEnergyNeed, false);
                }
                cellStorage.extractEnergy(stackEnergyNeed, false);
            }
        }
    }

    @Override
    public ResourceLocation getGunIcon() {
        return Mod.loc("textures/gun_icon/secondary_cataclysm_icon.png");
    }

    @Override
    public String getGunDisplayName() {
        return "SECONDARY CATACLYSM";
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new SecondaryCataclysmImageComponent(pStack));
    }

    @Override
    public String getAmmoDisplayName(GunData data) {
        return "40mm Grenade";
    }

    @Override
    public boolean shootBullet(Player player, GunData data, double spread, boolean zoom) {
        if (data.reloading()) {
            return false;
        }
        ItemStack stack = data.stack;
        IEnergyStorage stackCap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        boolean hasEnoughEnergy = stackCap != null && stackCap.getEnergyStored() >= 3000;
        boolean isChargedFire = zoom && hasEnoughEnergy;
        Level level = player.level();
        if (level instanceof ServerLevel) {
            IEnergyStorage itemCap;
            ServerLevel serverLevel = (ServerLevel)level;
            GunGrenadeEntity gunGrenadeEntity = new GunGrenadeEntity((LivingEntity)player, (Level)serverLevel, (float)data.damage(), (float)data.explosionDamage(), (float)data.explosionRadius());
            float velocity = (float)data.velocity();
            for (Perk.Type type : Perk.Type.values()) {
                PerkInstance instance = data.perk.getInstance(type);
                if (instance == null) continue;
                instance.perk().modifyProjectile(data, instance, (Entity)gunGrenadeEntity);
                Perk perk = instance.perk();
                if (!(perk instanceof AmmoPerk)) continue;
                AmmoPerk ammoPerk = (AmmoPerk)perk;
                velocity = (float)ammoPerk.getModifiedVelocity(data, instance);
            }
            gunGrenadeEntity.charged(isChargedFire);
            gunGrenadeEntity.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
            gunGrenadeEntity.shoot(player.getLookAngle().x, player.getLookAngle().y, player.getLookAngle().z, (float)(isChargedFire ? 4 : 1) * velocity, (float)(zoom ? 0.1 : spread));
            serverLevel.addFreshEntity((Entity)gunGrenadeEntity);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, player.getX() + 1.8 * player.getLookAngle().x, player.getEyeY() - 0.35 + 1.8 * player.getLookAngle().y, player.getZ() + 1.8 * player.getLookAngle().z, 4, 0.1, 0.1, 0.1, 0.002, true);
            if (isChargedFire && (itemCap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
                itemCap.extractEnergy(3000, false);
            }
        }
        return true;
    }

    @Override
    public void playFireSounds(GunData data, Player player, boolean zoom) {
        IEnergyStorage cap = (IEnergyStorage)data.stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap != null && cap.getEnergyStored() > 3000 && zoom) {
            float soundRadius = (float)data.soundRadius();
            player.playSound((SoundEvent)ModSounds.SECONDARY_CATACLYSM_FIRE_3P_CHARGE.get(), soundRadius * 0.4f, 1.0f);
            player.playSound((SoundEvent)ModSounds.SECONDARY_CATACLYSM_FAR_CHARGE.get(), soundRadius * 0.7f, 1.0f);
            player.playSound((SoundEvent)ModSounds.SECONDARY_CATACLYSM_VERYFAR_CHARGE.get(), soundRadius, 1.0f);
        } else {
            super.playFireSounds(data, player, zoom);
        }
    }

    @Override
    public int getMaxEnergy() {
        return 24000;
    }
}

