/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.rifle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.ClickHandler;
import com.atsuishio.superbwarfare.client.renderer.gun.Mk14ItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.GunsTool;
import com.atsuishio.superbwarfare.tools.NBTTool;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class Mk14Item
extends GunItem {
    public Mk14Item() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    @Override
    public Supplier<GeoItemRenderer<? extends Item>> getRenderer() {
        return Mk14ItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<Mk14Item> event) {
        boolean grip;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mk_14.idle"));
        }
        GunData data = GunData.from(stack);
        boolean drum = data.attachment.get(AttachmentType.MAGAZINE) == 2;
        boolean bl = grip = data.attachment.get(AttachmentType.GRIP) == 1 || data.attachment.get(AttachmentType.GRIP) == 2;
        if (data.reload.empty()) {
            if (drum) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk_14.reload_empty_drum_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk_14.reload_empty_drum"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk_14.reload_empty_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk_14.reload_empty"));
        }
        if (data.reload.normal()) {
            if (drum) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk_14.reload_normal_drum_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk_14.reload_normal_drum"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk_14.reload_normal_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk_14.reload_normal"));
        }
        if (player.isSprinting() && player.onGround() && ClientEventHandler.cantSprint == 0.0f && ClientEventHandler.drawTime < 0.01) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mk_14.run_fast"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk_14.run_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mk_14.run"));
        }
        if (grip) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mk_14.idle_grip"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mk_14.idle"));
    }

    private PlayState editPredicate(AnimationState<Mk14Item> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mk_14.idle"));
        }
        if (ClickHandler.isEditing) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mk_14.edit"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mk_14.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 3, this::idlePredicate);
        data.add(idleController);
        AnimationController editController = new AnimationController((GeoAnimatable)this, "editController", 1, this::editPredicate);
        data.add(editController);
    }

    @Override
    public int getCustomMagazine(ItemStack stack) {
        int magType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.MAGAZINE);
        return switch (magType) {
            case 1 -> 10;
            case 2 -> 30;
            default -> 0;
        };
    }

    @Override
    public double getCustomZoom(ItemStack stack) {
        int scopeType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE);
        return switch (scopeType) {
            case 2 -> 2.25;
            case 3 -> GunsTool.getGunDoubleTag(NBTTool.getTag(stack), "CustomZoom");
            default -> 0.0;
        };
    }

    @Override
    public boolean canAdjustZoom(ItemStack stack) {
        return GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE) == 3;
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.MK_14_RELOAD_EMPTY.get(), (SoundEvent)ModSounds.MK_14_RELOAD_NORMAL.get());
    }

    @Override
    public ResourceLocation getGunIcon() {
        return Mod.loc("textures/gun_icon/mk_14_icon.png");
    }

    @Override
    public String getGunDisplayName() {
        return "MK-14";
    }

    @Override
    public boolean isOpenBolt(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasBulletInBarrel(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isCustomizable(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomBarrel(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomGrip(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomMagazine(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomScope(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomStock(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canEjectShell(ItemStack stack) {
        return true;
    }

    @Override
    public void addReloadTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
        super.addReloadTimeBehavior(behaviors);
        behaviors.put(18, data -> data.holdOpen.set(false));
    }
}

