/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.sniper;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.gun.HuntingRifleItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class HuntingRifleItem
extends GunItem {
    public HuntingRifleItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.HUNTING_RIFLE_RELOAD_EMPTY.get());
    }

    @Override
    public Supplier<GeoItemRenderer<? extends Item>> getRenderer() {
        return HuntingRifleItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<HuntingRifleItem> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.hunting_rifle.idle"));
        }
        if (GunData.from((ItemStack)stack).reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.hunting_rifle.reload"));
        }
        if (player.isSprinting() && player.onGround() && ClientEventHandler.cantSprint == 0.0f && ClientEventHandler.drawTime < 0.01) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.hunting_rifle.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.hunting_rifle.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.hunting_rifle.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 4, this::idlePredicate);
        data.add(idleController);
    }

    @Override
    public ResourceLocation getGunIcon() {
        return Mod.loc("textures/gun_icon/hunting_rifle_icon.png");
    }

    @Override
    public String getGunDisplayName() {
        return "Hunting Rifle";
    }
}

