/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.special;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.gun.TaserItemRenderer;
import com.atsuishio.superbwarfare.client.tooltip.component.EnergyImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.TaserBulletEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.EnergyStorageItem;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class TaserItem
extends GunItem
implements EnergyStorageItem {
    public static final int MAX_ENERGY = 6000;

    public TaserItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON));
    }

    @Override
    public boolean isBarVisible(@NotNull ItemStack stack) {
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return cap != null && cap.getEnergyStored() != 0;
    }

    @Override
    public int getBarWidth(@NotNull ItemStack stack) {
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return Math.round((float)(cap != null ? cap.getEnergyStored() : 0) * 13.0f / 6000.0f);
    }

    @Override
    public int getBarColor(@NotNull ItemStack pStack) {
        return 0xFFFF00;
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.TASER_RELOAD_EMPTY.get());
    }

    @Override
    public Supplier<GeoItemRenderer<? extends Item>> getRenderer() {
        return TaserItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<TaserItem> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.taser.idle"));
        }
        if (GunData.from((ItemStack)stack).reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.taser.reload"));
        }
        if (player.isSprinting() && player.onGround() && ClientEventHandler.cantSprint == 0.0f && ClientEventHandler.drawTime < 0.01) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.taser.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.taser.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.taser.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 3, this::idlePredicate);
        data.add(idleController);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack cell : player.getInventory().items) {
                IEnergyStorage stackStorage;
                if (!cell.is((Item)ModItems.CELL.get()) || (stackStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null) continue;
                int stackMaxEnergy = stackStorage.getMaxEnergyStored();
                int stackEnergy = stackStorage.getEnergyStored();
                IEnergyStorage cellStorage = (IEnergyStorage)cell.getCapability(Capabilities.EnergyStorage.ITEM);
                if (cellStorage == null) continue;
                int cellEnergy = cellStorage.getEnergyStored();
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0) {
                    stackStorage.receiveEnergy(stackEnergyNeed, false);
                }
                cellStorage.extractEnergy(stackEnergyNeed, false);
            }
        }
    }

    @Override
    public ResourceLocation getGunIcon() {
        return Mod.loc("textures/gun_icon/taser_icon.png");
    }

    @Override
    public String getGunDisplayName() {
        return "TASER";
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new EnergyImageComponent(pStack));
    }

    @Override
    public String getAmmoDisplayName(GunData data) {
        return "Electrode Rod";
    }

    @Override
    public boolean shootBullet(Player player, GunData data, double spread, boolean zoom) {
        ItemStack stack = data.stack;
        player.getCooldowns().addCooldown(stack.getItem(), 5);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Level level = serverPlayer.level();
            TaserBulletEntity projectile = new TaserBulletEntity((LivingEntity)player, level, (float)data.damage());
            for (Perk.Type type : Perk.Type.values()) {
                PerkInstance instance = data.perk.getInstance(type);
                if (instance == null) continue;
                instance.perk().modifyProjectile(data, instance, (Entity)projectile);
            }
            projectile.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
            projectile.shoot(player.getLookAngle().x, player.getLookAngle().y, player.getLookAngle().z, (float)data.velocity(), (float)(zoom ? 0.1 : spread));
            level.addFreshEntity((Entity)projectile);
        }
        return true;
    }

    @Override
    public void afterShoot(GunData data, Player player) {
        super.afterShoot(data, player);
        ItemStack stack = data.stack;
        short perkLevel = data.perk.getLevel(ModPerks.VOLT_OVERLOAD);
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage != null) {
            energyStorage.extractEnergy(400 + 100 * perkLevel, false);
        }
    }

    @Override
    public boolean canShoot(GunData data) {
        boolean hasEnoughEnergy;
        ItemStack stack = data.stack;
        short perkLevel = data.perk.getLevel(ModPerks.VOLT_OVERLOAD);
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        boolean bl = hasEnoughEnergy = energyStorage != null && energyStorage.getEnergyStored() >= 400 + 100 * perkLevel;
        if (!hasEnoughEnergy) {
            return false;
        }
        if (data.reloading()) {
            return false;
        }
        return super.canShoot(data);
    }

    @Override
    public int getMaxEnergy() {
        return 6000;
    }
}

