/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.Mod;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ClientMotionSyncMessage(int id, float x, float y, float z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientMotionSyncMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("client_motion_sync"));
    public static final StreamCodec<ByteBuf, ClientMotionSyncMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClientMotionSyncMessage::id, (StreamCodec)ByteBufCodecs.FLOAT, ClientMotionSyncMessage::x, (StreamCodec)ByteBufCodecs.FLOAT, ClientMotionSyncMessage::y, (StreamCodec)ByteBufCodecs.FLOAT, ClientMotionSyncMessage::z, ClientMotionSyncMessage::new);

    public ClientMotionSyncMessage(Entity entity) {
        this(entity.getId(), (float)entity.getDeltaMovement().x, (float)entity.getDeltaMovement().y, (float)entity.getDeltaMovement().z);
    }

    public static void handler(ClientMotionSyncMessage message, IPayloadContext context) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(message.id);
        if (entity != null) {
            entity.lerpMotion((double)message.x, (double)message.y, (double)message.z);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

