/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.tools.Ammo;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public record PlayerVariablesSyncMessage(int target, Map<Byte, Integer> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("player_variable_sync"));
    public static final StreamCodec<ByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PlayerVariablesSyncMessage::target, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.BYTE, (StreamCodec)ByteBufCodecs.VAR_INT, (int)256), PlayerVariablesSyncMessage::data, PlayerVariablesSyncMessage::new);

    public static void handler(PlayerVariablesSyncMessage message) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        Entity entity = Minecraft.getInstance().player.level().getEntity(message.target());
        if (entity == null) {
            return;
        }
        PlayerVariable variable = (PlayerVariable)entity.getData(ModAttachments.PLAYER_VARIABLE);
        Map<Byte, Integer> map = message.data();
        for (Map.Entry<Byte, Integer> entry : map.entrySet()) {
            Byte type = entry.getKey();
            if (type == -1) {
                variable.tacticalSprint = entry.getValue() == 1;
                continue;
            }
            Ammo[] ammoTypes = Ammo.values();
            if (type >= ammoTypes.length) continue;
            Ammo ammo = ammoTypes[type];
            variable.ammo.put(ammo, entry.getValue());
        }
        entity.setData(ModAttachments.PLAYER_VARIABLE, (Object)variable);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

