/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.subdata.Attachment;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SoundTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record EditMessage(int msgType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EditMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("edit"));
    public static final StreamCodec<ByteBuf, EditMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, EditMessage::msgType, EditMessage::new);

    public static void handler(EditMessage message, IPayloadContext context) {
        EditMessage.pressAction(context.player(), message.msgType);
    }

    public static void pressAction(Player player, int type) {
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        Attachment attachment = data.attachment;
        switch (type) {
            case 0: {
                int att = attachment.get(AttachmentType.SCOPE);
                ++att;
                attachment.set(AttachmentType.SCOPE, att %= 4);
                break;
            }
            case 1: {
                int att = attachment.get(AttachmentType.BARREL);
                ++att;
                attachment.set(AttachmentType.BARREL, att %= 3);
                break;
            }
            case 2: {
                int att = attachment.get(AttachmentType.MAGAZINE);
                ++att;
                attachment.set(AttachmentType.MAGAZINE, att %= 3);
                break;
            }
            case 3: {
                int att = attachment.get(AttachmentType.STOCK);
                ++att;
                attachment.set(AttachmentType.STOCK, att %= 3);
                break;
            }
            case 4: {
                int att = attachment.get(AttachmentType.GRIP);
                ++att;
                attachment.set(AttachmentType.GRIP, att %= 4);
            }
        }
        data.save();
        SoundTool.playLocalSound(player, (SoundEvent)ModSounds.EDIT.get(), 1.0f, 1.0f);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

