/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SoundTool;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record FireModeMessage(int msgType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FireModeMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("fire_mode"));
    public static final StreamCodec<ByteBuf, FireModeMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, FireModeMessage::msgType, FireModeMessage::new);

    public static void handler(FireModeMessage message, IPayloadContext context) {
        FireModeMessage.changeFireMode(context.player());
    }

    public static void changeFireMode(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof GunItem) {
            GunData data = GunData.from(stack);
            CompoundTag tag = data.tag();
            FireMode fireMode = data.fireMode.get();
            Set<FireMode> mode = data.getAvailableFireModes();
            if (fireMode == FireMode.SEMI) {
                if (mode.contains((Object)FireMode.BURST)) {
                    data.fireMode.set(FireMode.BURST);
                    FireModeMessage.playChangeModeSound(player);
                    data.save();
                    return;
                }
                if (mode.contains((Object)FireMode.AUTO)) {
                    data.fireMode.set(FireMode.AUTO);
                    FireModeMessage.playChangeModeSound(player);
                    data.save();
                    return;
                }
            }
            if (fireMode == FireMode.BURST) {
                if (mode.contains((Object)FireMode.AUTO)) {
                    data.fireMode.set(FireMode.AUTO);
                    FireModeMessage.playChangeModeSound(player);
                    data.save();
                    return;
                }
                if (mode.contains((Object)FireMode.SEMI)) {
                    data.fireMode.set(FireMode.SEMI);
                    FireModeMessage.playChangeModeSound(player);
                    data.save();
                    return;
                }
            }
            if (fireMode == FireMode.AUTO) {
                if (mode.contains((Object)FireMode.SEMI)) {
                    data.fireMode.set(FireMode.SEMI);
                    FireModeMessage.playChangeModeSound(player);
                    data.save();
                    return;
                }
                if (mode.contains((Object)FireMode.BURST)) {
                    data.fireMode.set(FireMode.BURST);
                    FireModeMessage.playChangeModeSound(player);
                    data.save();
                    return;
                }
            }
            if (!(stack.getItem() != ModItems.SENTINEL.get() || player.isSpectator() || player.getCooldowns().isOnCooldown(stack.getItem()) || data.reload.time() != 0 || data.charging())) {
                for (ItemStack cell : player.getInventory().items) {
                    IEnergyStorage cap;
                    if (!cell.is((Item)ModItems.CELL.get()) || (cap = (IEnergyStorage)cell.getCapability(Capabilities.EnergyStorage.ITEM)) == null || cap.getEnergyStored() <= 0) continue;
                    data.charge.starter.markStart();
                }
            }
            if (stack.getItem() == ModItems.JAVELIN.get()) {
                tag.putBoolean("TopMode", !tag.getBoolean("TopMode"));
                data.save();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.CANNON_ZOOM_OUT.get());
                }
            }
        }
    }

    private static void playChangeModeSound(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.FIRE_RATE.get());
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

