/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record InteractMessage(int msgType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InteractMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("interact"));
    public static final StreamCodec<ByteBuf, InteractMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, InteractMessage::msgType, InteractMessage::new);

    public static void handler(InteractMessage message, IPayloadContext context) {
        InteractMessage.handleInteract(context.player(), message.msgType);
    }

    public static void handleInteract(Player player, int type) {
        DroneEntity drone;
        Level level = player.level();
        ItemStack stack = player.getMainHandItem();
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.getItem() instanceof GunItem) {
            Entity lookingEntity;
            double blockRange = player.blockInteractionRange();
            double entityRange = player.blockInteractionRange();
            Vec3 looking = Vec3.atLowerCornerOf((Vec3i)player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(player.getLookAngle().scale(blockRange)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).getBlockPos());
            BlockPos blockPos = BlockPos.containing((double)looking.x(), (double)looking.y(), (double)looking.z());
            level.getBlockState(blockPos).useItemOn(player.getMainHandItem(), player.level(), player, InteractionHand.MAIN_HAND, BlockHitResult.miss((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (Direction)Direction.UP, (BlockPos)blockPos));
            Block block = level.getBlockState(BlockPos.containing((double)looking.x(), (double)looking.y(), (double)looking.z())).getBlock();
            if (block instanceof BellBlock) {
                BellBlock bell = (BellBlock)block;
                bell.attemptToRing(level, blockPos, player.getDirection().getOpposite());
            }
            if ((lookingEntity = TraceTool.findLookingEntity((Entity)player, entityRange)) == null) {
                return;
            }
            player.interactOn(lookingEntity, InteractionHand.MAIN_HAND);
        } else if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked") && !player.getCooldowns().isOnCooldown(stack.getItem()) && (drone = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"))) != null) {
            Vec3 looking = Vec3.atLowerCornerOf((Vec3i)player.level().clip(new ClipContext(drone.getEyePosition(), drone.getEyePosition().add(drone.getLookAngle().scale(2.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).getBlockPos());
            BlockPos blockPos = BlockPos.containing((double)looking.x(), (double)looking.y(), (double)looking.z());
            player.level().getBlockState(blockPos).useItemOn(player.getMainHandItem(), player.level(), player, InteractionHand.MAIN_HAND, BlockHitResult.miss((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (Direction)Direction.UP, (BlockPos)blockPos));
            Entity lookingEntity = TraceTool.findLookingEntity(drone, 2.0);
            if (lookingEntity == null) {
                return;
            }
            player.attack(lookingEntity);
            player.getCooldowns().addCooldown(stack.getItem(), 13);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

