/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ReloadType;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ReloadMessage(int msgType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ReloadMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("reload"));
    public static final StreamCodec<ByteBuf, ReloadMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ReloadMessage::msgType, ReloadMessage::new);

    public static void handler(ReloadMessage message, IPayloadContext context) {
        ReloadMessage.pressAction(context.player(), message.msgType);
    }

    public static void pressAction(Player player, int type) {
        if (type != 0) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        GunData data = GunData.from(stack);
        if (data.useBackpackAmmo()) {
            return;
        }
        if (!(player.isSpectator() || data.charging() || data.reloading() || data.reload.time() != 0 || data.bolt.actionTimer.get() != 0)) {
            boolean clipLoad;
            Set<ReloadType> reloadTypes = data.reloadTypes();
            boolean canSingleReload = reloadTypes.contains((Object)ReloadType.ITERATIVE);
            boolean canReload = reloadTypes.contains((Object)ReloadType.MAGAZINE) && !reloadTypes.contains((Object)ReloadType.CLIP);
            boolean bl = clipLoad = data.ammo.get() == 0 && reloadTypes.contains((Object)ReloadType.CLIP);
            if (!data.hasBackupAmmo(player)) {
                return;
            }
            if (canReload || clipLoad) {
                int magazine = data.magazine();
                int extra = gunItem.isOpenBolt(stack) && gunItem.hasBulletInBarrel(stack) ? 1 : 0;
                int maxAmmo = magazine + extra;
                if (data.ammo.get() < maxAmmo) {
                    data.reload.reloadStarter.markStart();
                }
                return;
            }
            if (canSingleReload && data.ammo.get() < data.magazine()) {
                data.reload.singleReloadStarter.markStart();
            }
            data.save();
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

