/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ShootMessage(double spread, boolean zoom) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShootMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("shoot"));
    public static final StreamCodec<ByteBuf, ShootMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, ShootMessage::spread, (StreamCodec)ByteBufCodecs.BOOL, ShootMessage::zoom, ShootMessage::new);

    public static void handler(ShootMessage message, IPayloadContext context) {
        ShootMessage.pressAction(context.player(), message.spread, message.zoom);
    }

    public static void pressAction(Player player, double spread, boolean zoom) {
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        data.item.onShoot(data, player, spread, zoom);
        data.save();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

