/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record VehicleFireMessage(int msgType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<VehicleFireMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("vehicle_fire"));
    public static final StreamCodec<ByteBuf, VehicleFireMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, VehicleFireMessage::msgType, VehicleFireMessage::new);

    public static void handler(VehicleFireMessage message, IPayloadContext context) {
        Player player = context.player();
        Entity entity = player.getVehicle();
        if (entity instanceof ArmedVehicleEntity) {
            ArmedVehicleEntity iVehicle = (ArmedVehicleEntity)entity;
            iVehicle.vehicleShoot(player, message.msgType);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

