/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk;

import com.atsuishio.superbwarfare.data.gun.DamageReduce;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;

public class AmmoPerk
extends Perk {
    public float bypassArmorRate;
    public float damageRate;
    public float speedRate;
    public boolean slug;
    public float[] rgb;
    public Supplier<ArrayList<MobEffect>> mobEffects;

    public AmmoPerk(Builder builder) {
        super(builder.descriptionId, builder.type);
        this.bypassArmorRate = builder.bypassArmorRate;
        this.damageRate = builder.damageRate;
        this.speedRate = builder.speedRate;
        this.slug = builder.slug;
        this.rgb = builder.rgb;
        this.mobEffects = () -> builder.mobEffects;
    }

    public AmmoPerk(String descriptionId, Perk.Type type) {
        super(descriptionId, type);
        this.rgb = new float[]{1.0f, 0.87058824f, 0.15294118f};
        this.mobEffects = ArrayList::new;
    }

    @Override
    public void modifyProjectile(GunData data, PerkInstance instance, Entity entity) {
        if (!(entity instanceof ProjectileEntity)) {
            return;
        }
        ProjectileEntity projectile = (ProjectileEntity)entity;
        projectile.setRGB(this.rgb);
        projectile.bypassArmorRate((float)Math.max((double)this.bypassArmorRate + data.bypassArmor(), 0.0));
        if (this.slug) {
            projectile.setDamage((float)(data.damage() * (double)data.projectileAmount()));
        }
        if (!this.mobEffects.get().isEmpty()) {
            int amplifier = this.getEffectAmplifier(instance);
            ArrayList<MobEffectInstance> mobEffectInstances = new ArrayList<MobEffectInstance>();
            for (MobEffect effect : this.mobEffects.get()) {
                mobEffectInstances.add(new MobEffectInstance(Holder.direct((Object)effect), 70 + 30 * this.level, amplifier));
            }
            projectile.effect(mobEffectInstances);
        }
    }

    public int getEffectAmplifier(PerkInstance instance) {
        return instance.level() - 1;
    }

    public double getModifiedVelocity(GunData data, PerkInstance instance) {
        return data.velocity() * (double)this.speedRate;
    }

    @Override
    public double getModifiedDamageReduceRate(DamageReduce reduce) {
        if (this.slug && reduce.type == DamageReduce.ReduceType.SHOTGUN) {
            return 0.015;
        }
        return super.getModifiedDamageReduceRate(reduce);
    }

    @Override
    public double getModifiedDamageReduceMinDistance(DamageReduce reduce) {
        if (this.slug && reduce.type == DamageReduce.ReduceType.SHOTGUN) {
            return super.getModifiedDamageReduceMinDistance(reduce) * 2.0;
        }
        return super.getModifiedDamageReduceMinDistance(reduce);
    }

    public static class Builder {
        String descriptionId;
        Perk.Type type;
        float bypassArmorRate = 0.0f;
        float damageRate = 1.0f;
        float speedRate = 1.0f;
        boolean slug = false;
        float[] rgb = new float[]{1.0f, 0.87058824f, 0.15294118f};
        public ArrayList<MobEffect> mobEffects = new ArrayList();

        public Builder(String descriptionId, Perk.Type type) {
            this.descriptionId = descriptionId;
            this.type = type;
        }

        public Builder bypassArmorRate(float bypassArmorRate) {
            this.bypassArmorRate = Mth.clamp((float)bypassArmorRate, (float)-1.0f, (float)1.0f);
            return this;
        }

        public Builder damageRate(float damageRate) {
            this.damageRate = Mth.clamp((float)damageRate, (float)0.0f, (float)Float.POSITIVE_INFINITY);
            return this;
        }

        public Builder speedRate(float speedRate) {
            this.speedRate = Mth.clamp((float)speedRate, (float)0.0f, (float)Float.POSITIVE_INFINITY);
            return this;
        }

        public Builder slug(boolean slug) {
            this.slug = slug;
            return this;
        }

        public Builder rgb(int r, int g, int b) {
            this.rgb[0] = (float)r / 255.0f;
            this.rgb[1] = (float)g / 255.0f;
            this.rgb[2] = (float)b / 255.0f;
            return this;
        }

        public Builder mobEffect(Supplier<MobEffect> mobEffect) {
            this.mobEffects.add(mobEffect.get());
            return this;
        }
    }
}

