/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.ammo;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import net.minecraft.world.entity.Entity;

public class MicroMissile
extends AmmoPerk {
    public MicroMissile() {
        super(new AmmoPerk.Builder("micro_missile", Perk.Type.AMMO).speedRate(1.2f));
    }

    @Override
    public void modifyProjectile(GunData data, PerkInstance instance, Entity entity) {
        float radius = (float)(data.explosionRadius() * 0.5);
        float damage = (float)data.explosionDamage() * (1.1f + (float)instance.level() * 0.1f);
        entity.setNoGravity(true);
        if (entity instanceof ExplosiveProjectile) {
            ExplosiveProjectile projectile = (ExplosiveProjectile)entity;
            projectile.setExplosionRadius(radius);
            projectile.setExplosionDamage(damage);
        }
    }

    @Override
    public double getDisplayDamage(double damage, GunData data, PerkInstance instance) {
        return damage * (double)(1.1f + (float)instance.level() * 0.1f);
    }
}

