/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.damage;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class Firefly
extends Perk {
    public Firefly() {
        super("firefly", Perk.Type.DAMAGE);
    }

    @Override
    public void onKill(GunData data, PerkInstance instance, LivingEntity target, DamageSource source) {
        Projectile p;
        Entity entity;
        if (!DamageTypeTool.isHeadshotDamage(source)) {
            return;
        }
        Player attacker = null;
        Entity entity2 = source.getEntity();
        if (entity2 instanceof Player) {
            Player player;
            attacker = player = (Player)entity2;
        }
        if ((entity = source.getDirectEntity()) instanceof Projectile && (entity = (p = (Projectile)entity).getOwner()) instanceof Player) {
            Player player;
            attacker = player = (Player)entity;
        }
        if (attacker == null) {
            return;
        }
        CustomExplosion explosion = new CustomExplosion(target.level(), (Entity)attacker, ModDamageTypes.causeProjectileBoomDamage(target.level().registryAccess(), null, (Entity)attacker), 6 + instance.level() * 2, target.getX(), target.getY(), target.getZ(), 2.0f + (float)instance.level() * 0.5f, Explosion.BlockInteraction.KEEP, false).setFireTime(3 + instance.level() / 3);
        explosion.explode();
        EventHooks.onExplosionStart((Level)target.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        ParticleTool.spawnSmallExplosionParticles(target.level(), target.position());
    }
}

