/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.functional;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class HealClip
extends Perk {
    public HealClip() {
        super("heal_clip", Perk.Type.FUNCTIONAL);
    }

    @Override
    public void tick(GunData data, PerkInstance instance, @Nullable LivingEntity living) {
        data.perk.reduceCooldown(this, "HealClipTime");
    }

    @Override
    public void onKill(GunData data, PerkInstance instance, LivingEntity target, DamageSource source) {
        short healClipLevel;
        if ((DamageTypeTool.isGunDamage(source) || source.is(ModDamageTypes.PROJECTILE_BOOM)) && (healClipLevel = instance.level()) != 0) {
            data.perk.getTag(this).putInt("HealClipTime", 80 + healClipLevel * 20);
        }
    }

    @Override
    public void preReload(GunData data, PerkInstance instance, @Nullable LivingEntity living) {
        int time = data.perk.getTag(this).getInt("HealClipTime");
        if (time > 0) {
            data.perk.getTag(this).remove("HealClipTime");
            data.perk.getTag(this).putBoolean("HealClip", true);
        } else {
            data.perk.getTag(this).remove("HealClip");
        }
    }

    @Override
    public void postReload(GunData data, PerkInstance instance, @Nullable LivingEntity living) {
        if (living == null) {
            return;
        }
        if (!data.perk.getTag(this).contains("HealClip")) {
            return;
        }
        short healClipLevel = instance.level();
        if (healClipLevel == 0) {
            healClipLevel = 1;
        }
        living.heal(12.0f * (0.8f + 0.2f * (float)healClipLevel));
        List<Player> players = living.level().getEntitiesOfClass(Player.class, living.getBoundingBox().inflate(5.0)).stream().filter(p -> p.isAlliedTo((Entity)living)).toList();
        short finalHealClipLevel = healClipLevel;
        players.forEach(p -> p.heal(6.0f * (0.8f + 0.2f * (float)finalHealClipLevel)));
    }
}

