/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PotionMortarShellRecipe
extends CustomRecipe {
    public PotionMortarShellRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level pLevel) {
        if (input.width() == 3 && input.height() == 3) {
            for (int i = 0; i < input.width(); ++i) {
                for (int j = 0; j < input.height(); ++j) {
                    int index = i + j * input.width();
                    ItemStack itemstack = input.getItem(index);
                    if (!(index % 2 == 0 ? (i == 1 && j == 1 ? !itemstack.is(Items.LINGERING_POTION) : !itemstack.isEmpty()) : !itemstack.is((Item)ModItems.MORTAR_SHELL.get()))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack stack = input.getItem(1 + input.width());
        if (!stack.is(Items.LINGERING_POTION)) {
            return ItemStack.EMPTY;
        }
        ItemStack res = new ItemStack((ItemLike)ModItems.POTION_MORTAR_SHELL.get(), 4);
        res.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)));
        return res;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth >= 2 && pHeight >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.POTION_MORTAR_SHELL_SERIALIZER.get();
    }
}

