/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public class CustomExplosion
extends Explosion {
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final float damage;
    private int fireTime;
    private float damageMultiplier;

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator pDamageCalculator, float damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, Explosion.BlockInteraction pBlockInteraction, ParticleOptions smallParticle, ParticleOptions bigParticle, Holder<SoundEvent> sound) {
        super(pLevel, pSource, source, null, pToBlowX, pToBlowY, pToBlowZ, pRadius, false, pBlockInteraction, smallParticle, bigParticle, sound);
        this.level = pLevel;
        this.source = pSource;
        this.radius = pRadius;
        this.damageSource = source == null ? pLevel.damageSources().explosion((Explosion)this) : source;
        this.damageCalculator = pDamageCalculator == null ? new ExplosionDamageCalculator() : pDamageCalculator;
        this.x = pToBlowX;
        this.y = pToBlowY;
        this.z = pToBlowZ;
        this.damage = damage;
    }

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator pDamageCalculator, float damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, Explosion.BlockInteraction pBlockInteraction) {
        this(pLevel, pSource, source, pDamageCalculator, damage, pToBlowX, pToBlowY, pToBlowZ, pRadius, pBlockInteraction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder<SoundEvent>)SoundEvents.GENERIC_EXPLODE);
    }

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, float damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, Explosion.BlockInteraction pBlockInteraction) {
        this(pLevel, pSource, null, null, damage, pToBlowX, pToBlowY, pToBlowZ, pRadius, pBlockInteraction);
    }

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource source, float damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, Explosion.BlockInteraction pBlockInteraction, boolean vanillaExplode) {
        this(pLevel, pSource, source, null, damage, pToBlowX, pToBlowY, pToBlowZ, pRadius, pBlockInteraction);
        Vec3 center = new Vec3(pToBlowX, pToBlowY, pToBlowZ);
        if (pLevel instanceof ServerLevel && vanillaExplode) {
            pLevel.explode(source == null ? null : source.getEntity(), pToBlowX, pToBlowY, pToBlowZ, 0.4f * pRadius, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
        }
        for (Entity target : this.level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate((double)(4.0f * this.radius)), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
            if (!(target instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)target;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(20.0 + 0.02 * (double)damage, 3.0f * pRadius, 50.0 + 0.05 * (double)damage, pToBlowX, pToBlowY, pToBlowZ), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource source, float damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, Explosion.BlockInteraction pBlockInteraction) {
        this(pLevel, pSource, source, null, damage, pToBlowX, pToBlowY, pToBlowZ, pRadius, pBlockInteraction);
        Vec3 center = new Vec3(pToBlowX, pToBlowY, pToBlowZ);
        for (Entity target : this.level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate((double)(4.0f * this.radius)), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
            if (!(target instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)target;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(5.0 + 0.02 * (double)damage, 0.75 * (double)pRadius, 4.0 + 0.02 * (double)damage, pToBlowX, pToBlowY, pToBlowZ), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public CustomExplosion(Level pLevel, @Nullable Entity pSource, @Nullable DamageSource source, float damage, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius) {
        this(pLevel, pSource, source, null, damage, pToBlowX, pToBlowY, pToBlowZ, pRadius, Explosion.BlockInteraction.KEEP);
        Vec3 center = new Vec3(pToBlowX, pToBlowY, pToBlowZ);
        for (Entity target : this.level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate((double)this.radius), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
            if (!(target instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)target;
            if (target == pSource && pSource.getVehicle() != null) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(20.0 + 0.02 * (double)damage, pRadius, 10.0 + 0.03 * (double)damage, pToBlowX, pToBlowY, pToBlowZ), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public CustomExplosion setFireTime(int fireTime) {
        this.fireTime = fireTime;
        return this;
    }

    public CustomExplosion setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
        return this;
    }

    public CustomExplosion bulletExplode() {
        return this;
    }

    public void explode() {
        this.level.gameEvent(this.source, (Holder)GameEvent.EXPLODE, new Vec3(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    for (float f = this.radius * (0.2f + this.level.random.nextFloat() * 0.15f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.containing((double)d4, (double)d6, (double)d8);
                        BlockState blockstate = this.level.getBlockState(blockpos);
                        FluidState fluidstate = this.level.getFluidState(blockpos);
                        if (!this.level.isInWorldBounds(blockpos)) continue block2;
                        Optional optional = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 1.0f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.getToBlow().addAll(set);
        float diameter = this.radius * 2.0f;
        int x0 = Mth.floor((double)(this.x - (double)diameter - 1.0));
        int x1 = Mth.floor((double)(this.x + (double)diameter + 1.0));
        int y0 = Mth.floor((double)(this.y - (double)diameter - 1.0));
        int y1 = Mth.floor((double)(this.y + (double)diameter + 1.0));
        int z0 = Mth.floor((double)(this.z - (double)diameter - 1.0));
        int z1 = Mth.floor((double)(this.z + (double)diameter + 1.0));
        List list = this.level.getEntities(this.source, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
        EventHooks.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)diameter);
        Vec3 position = new Vec3(this.x, this.y, this.z);
        for (Entity entity : list) {
            double zDistance;
            double yDistance;
            double xDistance;
            double distance;
            double distanceRate;
            if (entity.ignoreExplosion((Explosion)this) || !((distanceRate = Math.sqrt(entity.distanceToSqr(position)) / (double)diameter) <= 1.0) || (distance = Math.sqrt((xDistance = entity.getX() - this.x) * xDistance + (yDistance = (entity instanceof PrimedTnt ? entity.getY() : entity.getEyeY()) - this.y) * yDistance + (zDistance = entity.getZ() - this.z) * zDistance)) == 0.0) continue;
            double seenPercent = Mth.clamp((double)CustomExplosion.getSeenPercent((Vec3)position, (Entity)entity), (double)(0.01 * (double)((Integer)ExplosionConfig.EXPLOSION_PENETRATION_RATIO.get()).intValue()), (double)Double.POSITIVE_INFINITY);
            double damagePercent = (1.0 - distanceRate) * seenPercent;
            double damageFinal = (damagePercent * damagePercent + damagePercent) / 2.0 * (double)this.damage;
            if (entity instanceof Monster) {
                Monster monster = (Monster)entity;
                monster.hurt(this.damageSource, (float)damageFinal * (1.0f + 0.2f * this.damageMultiplier));
            } else {
                entity.hurt(this.damageSource, (float)damageFinal);
            }
            entity.invulnerableTime = 1;
            if (this.fireTime <= 0) continue;
            entity.setRemainingFireTicks(this.fireTime);
        }
    }
}

