/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.init.ModItems;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class InventoryTool {
    public static int countItem(NonNullList<ItemStack> itemList, @NotNull Item item) {
        return itemList.stream().filter(stack -> stack.is(item)).mapToInt(ItemStack::getCount).sum();
    }

    public static int countItem(Player player, @NotNull Item item) {
        return InventoryTool.countItem((NonNullList<ItemStack>)player.getInventory().items, item);
    }

    public static boolean hasItem(Player player, @NotNull Item item) {
        return InventoryTool.countItem(player, item) > 0;
    }

    public static boolean hasItem(NonNullList<ItemStack> itemList, @NotNull Item item) {
        return InventoryTool.countItem(itemList, item) > 0;
    }

    public static boolean hasCreativeAmmoBox(NonNullList<ItemStack> itemList) {
        return InventoryTool.countItem(itemList, (Item)ModItems.CREATIVE_AMMO_BOX.get()) > 0;
    }

    public static boolean hasCreativeAmmoBox(Player player) {
        return InventoryTool.hasItem(player, (Item)ModItems.CREATIVE_AMMO_BOX.get());
    }

    public static int consumeItem(NonNullList<ItemStack> itemList, Item item, int count) {
        return InventoryTool.consumeItem(itemList, (ItemStack stack) -> stack.is(item), count);
    }

    public static int consumeItem(NonNullList<ItemStack> itemList, Predicate<ItemStack> predicate, int count) {
        int initialCount = count;
        List<ItemStack> items = itemList.stream().filter(predicate).toList();
        for (ItemStack stack : items) {
            int countToShrink = Math.min((int)stack.getCount(), (int)count);
            stack.shrink(countToShrink);
            if ((count -= countToShrink) > 0) continue;
            break;
        }
        return initialCount - count;
    }

    public static int insertItem(NonNullList<ItemStack> itemList, Item item, int count) {
        ItemStack defaultStack = new ItemStack((ItemLike)item);
        int maxStackSize = item.getMaxStackSize(defaultStack);
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack stack = (ItemStack)itemList.get(i);
            if (stack.is(item) && stack.getCount() < maxStackSize) {
                countToAdd = Math.min((int)(maxStackSize - stack.getCount()), (int)count);
                stack.grow(countToAdd);
                count -= countToAdd;
            } else if (stack.isEmpty()) {
                countToAdd = Math.min((int)maxStackSize, (int)count);
                itemList.set(i, (Object)new ItemStack((ItemLike)item, countToAdd));
                count -= countToAdd;
            }
            if (count <= 0) break;
        }
        return count;
    }

    public static int insertItem(NonNullList<ItemStack> itemList, ItemStack stack) {
        int maxStackSize = stack.getItem().getMaxStackSize(stack);
        int originalCount = stack.getCount();
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack currentStack = (ItemStack)itemList.get(i);
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)currentStack) && currentStack.getCount() < maxStackSize) {
                int countToAdd = Math.min((int)(maxStackSize - currentStack.getCount()), (int)stack.getCount());
                currentStack.grow(countToAdd);
                stack.setCount(stack.getCount() - countToAdd);
            } else if (currentStack.isEmpty()) {
                itemList.set(i, (Object)stack);
                return stack.getCount();
            }
            if (stack.getCount() <= 0) break;
        }
        return originalCount - stack.getCount();
    }
}

