/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import net.minecraft.world.phys.Vec3;

public class RangeTool {
    public static double getRange(double thetaDegrees, double v, double g) {
        double t = v * Math.sin(thetaDegrees * 0.01745329238474369) / g * 2.0;
        return t * v * Math.cos(thetaDegrees * 0.01745329238474369);
    }

    public static boolean canReach(double v, double g, Vec3 startPos, Vec3 endPos, double minAngle, double maxAngle, boolean isDepressedTrajectory) {
        if (RangeTool.getD(v, g, startPos, endPos) < 0.0) {
            return false;
        }
        double targetAngle = RangeTool.calculateAngle(v, g, startPos, endPos, isDepressedTrajectory);
        return targetAngle >= minAngle && targetAngle <= maxAngle;
    }

    public static double calculateAngle(double v, double g, Vec3 startPos, Vec3 endPos, boolean isDepressedTrajectory) {
        double xDiff = startPos.x - endPos.x;
        double zDiff = startPos.z - endPos.z;
        double x = Math.sqrt(Math.pow(xDiff, 2.0) + Math.pow(zDiff, 2.0));
        double d = RangeTool.getD(v, g, startPos, endPos);
        return Math.atan((v * v + (isDepressedTrajectory ? -d : d)) / (g * x)) * 57.2957763671875;
    }

    private static double getD(double v, double g, Vec3 startPos, Vec3 endPos) {
        double xDiff = startPos.x - endPos.x;
        double zDiff = startPos.z - endPos.z;
        double x = Math.sqrt(Math.pow(xDiff, 2.0) + Math.pow(zDiff, 2.0));
        double y = startPos.y - endPos.y;
        return Math.sqrt(Math.pow(v, 4.0) - g * g * x * x - 2.0 * g * y * v * v);
    }
}

