/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools.animation;

import com.atsuishio.superbwarfare.tools.animation.AnimationCurves;
import java.util.function.Function;
import net.minecraft.util.Mth;

public class AnimationTimer {
    private final long forwardDuration;
    private final long backwardDuration;
    private long startTime;
    private boolean isForward = true;
    private boolean initialized;
    private boolean playFromStart;
    private Function<Double, Double> forwardAnimationCurve = AnimationCurves.LINEAR;
    private Function<Double, Double> backwardAnimationCurve = AnimationCurves.LINEAR;

    public AnimationTimer(long duration) {
        this.forwardDuration = duration;
        this.backwardDuration = duration;
    }

    public AnimationTimer(long forwardDuration, long backwardDuration) {
        this.forwardDuration = forwardDuration;
        this.backwardDuration = backwardDuration;
    }

    public AnimationTimer animation(Function<Double, Double> animationCurve) {
        return this.forwardAnimation(animationCurve).backwardAnimation(animationCurve);
    }

    public AnimationTimer forwardAnimation(Function<Double, Double> animationCurve) {
        this.forwardAnimationCurve = animationCurve;
        return this;
    }

    public AnimationTimer backwardAnimation(Function<Double, Double> animationCurve) {
        this.backwardAnimationCurve = animationCurve;
        return this;
    }

    public static AnimationTimer[] createTimers(int size, long duration) {
        return AnimationTimer.createTimers(size, duration, AnimationCurves.LINEAR);
    }

    public static AnimationTimer[] createTimers(int size, long duration, Function<Double, Double> animationCurve) {
        return AnimationTimer.createTimers(size, duration, animationCurve, animationCurve);
    }

    public static AnimationTimer[] createTimers(int size, long duration, Function<Double, Double> forwardAnimationCurve, Function<Double, Double> backwardAnimationCurve) {
        return AnimationTimer.createTimers(size, duration, duration, forwardAnimationCurve, backwardAnimationCurve);
    }

    public static AnimationTimer[] createTimers(int size, long forwardDuration, long backwardDuration, Function<Double, Double> forwardAnimationCurve, Function<Double, Double> backwardAnimationCurve) {
        AnimationTimer[] timers = new AnimationTimer[size];
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            timers[i] = new AnimationTimer(forwardDuration, backwardDuration).forwardAnimation(forwardAnimationCurve).backwardAnimation(backwardAnimationCurve);
            timers[i].endBackward(currentTime);
        }
        return timers;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public float getProgress(long currentTime) {
        if (this.isForward) {
            return this.forwardAnimationCurve.apply(Mth.clamp((double)((double)this.getElapsedTime(currentTime) / (double)this.forwardDuration), (double)0.0, (double)1.0)).floatValue();
        }
        return 1.0f - this.backwardAnimationCurve.apply(Mth.clamp((double)(1.0 - (double)this.getElapsedTime(currentTime) / (double)this.backwardDuration), (double)0.0, (double)1.0)).floatValue();
    }

    private long getElapsedTime(long currentTime) {
        if (!this.initialized) {
            return this.playFromStart ? 0L : (this.isForward() ? this.forwardDuration : this.backwardDuration);
        }
        if (this.isForward) {
            return Math.min(this.forwardDuration, currentTime - this.startTime);
        }
        return Math.min(this.backwardDuration, Math.max(0L, this.startTime - currentTime));
    }

    public boolean finished(long currentTime) {
        return this.getElapsedTime(currentTime) >= (this.isForward ? this.forwardDuration : this.backwardDuration);
    }

    public void begin() {
        this.initialized = false;
        this.playFromStart = true;
    }

    public void end() {
        this.initialized = false;
        this.playFromStart = false;
    }

    public void forward(long currentTime) {
        if (!this.initialized) {
            this.initialized = true;
            this.startTime = currentTime + (this.playFromStart ? 0L : this.forwardDuration);
        } else if (!this.isForward) {
            this.startTime = (long)((double)currentTime - (double)this.getElapsedTime(currentTime) / (double)this.backwardDuration * (double)this.forwardDuration);
        }
        this.isForward = true;
    }

    public void beginForward(long currentTime) {
        this.begin();
        this.forward(currentTime);
    }

    public void endForward(long currentTime) {
        this.end();
        this.forward(currentTime);
    }

    public void backward(long currentTime) {
        if (!this.initialized) {
            this.initialized = true;
            this.startTime = currentTime + (this.playFromStart ? this.backwardDuration : 0L);
        } else if (this.isForward) {
            this.startTime = (long)((double)currentTime + (double)this.getElapsedTime(currentTime) / (double)this.forwardDuration * (double)this.backwardDuration);
        }
        this.isForward = false;
    }

    public void beginBackward(long currentTime) {
        this.begin();
        this.backward(currentTime);
    }

    public void endBackward(long currentTime) {
        this.end();
        this.backward(currentTime);
    }

    public float lerp(float start, float end, long currentTime) {
        return Mth.lerp((float)this.getProgress(currentTime), (float)start, (float)end);
    }
}

