/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare;

import com.atsuishio.superbwarfare.api.event.RegisterContainersEvent;
import com.atsuishio.superbwarfare.block.entity.FuMO25BlockEntity;
import com.atsuishio.superbwarfare.client.MouseMovementHandler;
import com.atsuishio.superbwarfare.client.renderer.molang.MolangVariable;
import com.atsuishio.superbwarfare.client.sound.ModSoundInstances;
import com.atsuishio.superbwarfare.compat.CompatHolder;
import com.atsuishio.superbwarfare.compat.clothconfig.ClothConfigHelper;
import com.atsuishio.superbwarfare.compat.coldsweat.ColdSweatCompatHandler;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.config.ClientConfig;
import com.atsuishio.superbwarfare.config.CommonConfig;
import com.atsuishio.superbwarfare.config.ServerConfig;
import com.atsuishio.superbwarfare.init.ModArmorMaterials;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.init.ModAttributes;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModCriteriaTriggers;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModMenuTypes;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModPotion;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTabs;
import com.atsuishio.superbwarfare.init.ModVillagers;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.util.GeckoLibUtil;

@net.neoforged.fml.common.Mod(value="superbwarfare")
public class Mod {
    public static final String MODID = "superbwarfare";
    public static final ResourceLocation ATTRIBUTE_MODIFIER = Mod.loc("attribute_modifier");
    public static final Logger LOGGER = LogManager.getLogger(Mod.class);
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueueC = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public Mod(IEventBus bus, ModContainer container) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.init());
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.init());
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.init());
        ModPerks.register(bus);
        ModSerializers.REGISTRY.register(bus);
        ModSounds.REGISTRY.register(bus);
        ModBlocks.REGISTRY.register(bus);
        ModBlockEntities.REGISTRY.register(bus);
        ModItems.register(bus);
        ModDataComponents.register(bus);
        ModTabs.TABS.register(bus);
        ModEntities.REGISTRY.register(bus);
        ModMobEffects.REGISTRY.register(bus);
        ModParticleTypes.REGISTRY.register(bus);
        ModPotion.POTIONS.register(bus);
        ModMenuTypes.REGISTRY.register(bus);
        ModVillagers.register(bus);
        ModRecipes.RECIPE_SERIALIZERS.register(bus);
        ModArmorMaterials.MATERIALS.register(bus);
        ModAttributes.ATTRIBUTES.register(bus);
        ModCriteriaTriggers.REGISTRY.register(bus);
        ModAttachments.ATTACHMENT_TYPES.register(bus);
        bus.addListener(this::onClientSetup);
        bus.addListener(FMLCommonSetupEvent.class, event -> this.onCommonSetup(bus));
        bus.addListener(ModItems::registerDispenserBehavior);
        bus.addListener(NetworkRegistry::register);
        this.registerDataTickets();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            CompatHolder.hasMod("cloth_config", ClothConfigHelper::registerScreen);
        }
        if (ColdSweatCompatHandler.hasMod()) {
            NeoForge.EVENT_BUS.addListener(ColdSweatCompatHandler::onPlayerInVehicle);
        }
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    public static void queueClientWork(int tick, Runnable action) {
        workQueueC.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        this.executeWork(workQueue);
    }

    @SubscribeEvent
    public void tick(ClientTickEvent.Post event) {
        this.executeWork(workQueueC);
    }

    private void executeWork(Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueueC) {
        ArrayList actions = new ArrayList();
        workQueueC.forEach(work -> {
            work.setValue((Integer)work.getValue() - 1);
            if ((Integer)work.getValue() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getKey()).run());
        workQueueC.removeAll(actions);
    }

    public void onCommonSetup(IEventBus bus) {
        bus.post((Event)new RegisterContainersEvent());
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        MouseMovementHandler.init();
        MolangVariable.register();
        event.enqueueWork(ModSoundInstances::init);
    }

    private void registerDataTickets() {
        FuMO25BlockEntity.FUMO25_TICK = GeckoLibUtil.addDataTicket((SerializableDataTicket)SerializableDataTicket.ofInt((ResourceLocation)Mod.loc("fumo25_tick")));
    }
}

