/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AircraftCatapultBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final BooleanProperty UPDATING = BooleanProperty.create((String)"updating");

    public AircraftCatapultBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.0f).requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWER, (Comparable)Integer.valueOf(0))).setValue((Property)UPDATING, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    public void onPlace(@NotNull BlockState state, Level level, BlockPos pos, @NotNull BlockState pOldState, boolean pMovedByPiston) {
        if (level instanceof ServerLevel) {
            int receivedPower = level.getBestNeighborSignal(pos);
            int maxNeighborPower = this.getFacingPower(level, pos, state);
            int newPower = Math.max(receivedPower, maxNeighborPower);
            level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower)), 3);
        }
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{POWER}).add(new Property[]{UPDATING});
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @ParametersAreNonnullByDefault
    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.isClientSide && !((Boolean)pState.getValue((Property)UPDATING)).booleanValue()) {
            pLevel.scheduleTick(pPos, (Block)this, 1);
        }
    }

    @ParametersAreNonnullByDefault
    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource pRandom) {
        this.updateSignal(state, level, pos);
    }

    private void updateSignal(BlockState state, ServerLevel level, BlockPos pos) {
        BlockState newState;
        if (((Boolean)state.getValue((Property)UPDATING)).booleanValue()) {
            return;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)UPDATING, (Comparable)Boolean.valueOf(true)), 2);
        int receivedPower = level.getBestNeighborSignal(pos);
        int maxNeighborPower = this.getFacingPower((Level)level, pos, state);
        int newPower = Math.max(receivedPower, maxNeighborPower);
        if (newPower != (Integer)state.getValue((Property)POWER)) {
            newState = level.getBlockState(pos);
            level.setBlock(pos, (BlockState)newState.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower)), 3);
        }
        newState = level.getBlockState(pos);
        level.setBlock(pos, (BlockState)newState.setValue((Property)UPDATING, (Comparable)Boolean.valueOf(false)), 2);
    }

    private int getFacingPower(Level level, BlockPos pos, BlockState state) {
        int max = 0;
        BlockPos relative = pos.relative((Direction)state.getValue((Property)FACING));
        BlockState blockState = level.getBlockState(relative);
        if (blockState.getBlock() instanceof AircraftCatapultBlock) {
            max = Math.max(max, (Integer)blockState.getValue((Property)POWER));
        }
        return max;
    }

    @ParametersAreNonnullByDefault
    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        super.stepOn(pLevel, pPos, pState, pEntity);
        Direction direction = (Direction)pState.getValue((Property)FACING);
        int power = (Integer)pState.getValue((Property)POWER);
        if (power == 0) {
            return;
        }
        float rate = (float)power / 400.0f;
        if (pEntity instanceof LivingEntity) {
            rate = (float)power / 50.0f;
        }
        Vec3 vec3 = new Vec3((double)direction.getStepX(), 0.0, (double)direction.getStepZ());
        if (pEntity.getDeltaMovement().dot(vec3) < 0.2 * (double)power) {
            pEntity.addDeltaMovement(new Vec3((double)((float)direction.getStepX() * rate), 0.0, (double)((float)direction.getStepZ() * rate)));
        }
    }
}

