/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client;

import com.atsuishio.superbwarfare.compat.CompatHolder;
import com.atsuishio.superbwarfare.compat.clothconfig.ClothConfigHelper;
import com.atsuishio.superbwarfare.config.client.ReloadConfig;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.send.AdjustMortarAngleMessage;
import com.atsuishio.superbwarfare.network.message.send.AdjustZoomFovMessage;
import com.atsuishio.superbwarfare.network.message.send.DoubleJumpMessage;
import com.atsuishio.superbwarfare.network.message.send.DroneFireMessage;
import com.atsuishio.superbwarfare.network.message.send.EditMessage;
import com.atsuishio.superbwarfare.network.message.send.FireKeyMessage;
import com.atsuishio.superbwarfare.network.message.send.FireModeMessage;
import com.atsuishio.superbwarfare.network.message.send.InteractMessage;
import com.atsuishio.superbwarfare.network.message.send.PlayerStopRidingMessage;
import com.atsuishio.superbwarfare.network.message.send.ReloadMessage;
import com.atsuishio.superbwarfare.network.message.send.SensitivityMessage;
import com.atsuishio.superbwarfare.network.message.send.SetFiringParametersMessage;
import com.atsuishio.superbwarfare.network.message.send.SwitchScopeMessage;
import com.atsuishio.superbwarfare.network.message.send.SwitchVehicleWeaponMessage;
import com.atsuishio.superbwarfare.network.message.send.ZoomMessage;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClickHandler {
    public static boolean isEditing = false;
    public static boolean switchZoom = false;

    private static boolean notInGame() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return true;
        }
        if (mc.getOverlay() != null) {
            return true;
        }
        if (mc.screen != null) {
            return true;
        }
        if (!mc.mouseHandler.isMouseGrabbed()) {
            return true;
        }
        return !mc.isWindowActive();
    }

    @SubscribeEvent
    public static void onButtonReleased(InputEvent.MouseButton.Pre event) {
        if (ClickHandler.notInGame()) {
            return;
        }
        if (event.getAction() != 0) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.hasEffect(ModMobEffects.SHOCK)) {
            return;
        }
        int button = event.getButton();
        if (button == ModKeyMappings.FIRE.getKey().getValue()) {
            ClickHandler.handleWeaponFireRelease();
        }
        if (button == ModKeyMappings.HOLD_ZOOM.getKey().getValue()) {
            ClickHandler.handleWeaponZoomRelease();
            return;
        }
        if (button == ModKeyMappings.SWITCH_ZOOM.getKey().getValue() && !switchZoom) {
            ClickHandler.handleWeaponZoomRelease();
        }
    }

    @SubscribeEvent
    public static void onButtonPressed(InputEvent.MouseButton.Pre event) {
        ArmedVehicleEntity iArmedVehicle;
        Entity entity;
        if (ClickHandler.notInGame()) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        int button = event.getButton();
        if ((stack.getItem() instanceof GunItem || stack.is((Item)ModItems.MONITOR.get()) || stack.is((Item)ModItems.LUNGE_MINE.get()) || player.hasEffect(ModMobEffects.SHOCK) || (entity = player.getVehicle()) instanceof ArmedVehicleEntity && (iArmedVehicle = (ArmedVehicleEntity)entity).banHand((Player)player)) && button == 0) {
            event.setCanceled(true);
        }
        if (player.hasEffect(ModMobEffects.SHOCK)) {
            return;
        }
        if (button == 1 && (stack.getItem() instanceof GunItem || (entity = player.getVehicle()) instanceof ArmedVehicleEntity && (iArmedVehicle = (ArmedVehicleEntity)entity).isDriver((Player)player) && stack.get(DataComponents.FOOD) != null)) {
            event.setCanceled(true);
        }
        if (button == 2 && player.hasEffect(ModMobEffects.SHOCK)) {
            event.setCanceled(true);
        }
        if (stack.getItem() instanceof GunItem || stack.is((Item)ModItems.MONITOR.get()) || stack.is((Item)ModItems.LUNGE_MINE.get()) || player.getVehicle() instanceof ArmedVehicleEntity || stack.is(Items.SPYGLASS) && player.isScoping() && player.getOffhandItem().is((Item)ModItems.FIRING_PARAMETERS.get())) {
            if (button == ModKeyMappings.FIRE.getKey().getValue()) {
                ClickHandler.handleWeaponFirePress((Player)player, stack);
            }
            if (button == ModKeyMappings.HOLD_ZOOM.getKey().getValue()) {
                ClickHandler.handleWeaponZoomPress((Player)player, stack);
                switchZoom = false;
                return;
            }
            if (button == ModKeyMappings.SWITCH_ZOOM.getKey().getValue()) {
                ClickHandler.handleWeaponZoomPress((Player)player, stack);
                switchZoom = !switchZoom;
            }
        }
    }

    @SubscribeEvent
    public static void onMouseScrolling(InputEvent.MouseScrollingEvent event) {
        Entity looking;
        WeaponVehicleEntity weaponVehicle;
        Entity entity;
        VehicleEntity vehicle;
        LocalPlayer player = Minecraft.getInstance().player;
        if (ClickHandler.notInGame()) {
            return;
        }
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (player.hasEffect(ModMobEffects.SHOCK)) {
            return;
        }
        double scroll = event.getScrollDeltaY();
        Entity entity2 = player.getVehicle();
        if (entity2 instanceof VehicleEntity && player == (vehicle = (VehicleEntity)entity2).getFirstPassenger() && ModKeyMappings.FREE_CAMERA.isDown()) {
            ClientMouseHandler.custom3pDistance = Mth.clamp((double)(ClientMouseHandler.custom3pDistance - event.getScrollDeltaY()), (double)-3.0, (double)8.0);
            event.setCanceled(true);
            return;
        }
        if (!Screen.hasShiftDown() && (entity = player.getVehicle()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity) instanceof WeaponVehicleEntity && (weaponVehicle = (WeaponVehicleEntity)((Object)vehicle)).hasWeapon(vehicle.getSeatIndex((Entity)player)) && weaponVehicle.banHand((Player)player)) {
            int index = vehicle.getSeatIndex((Entity)player);
            PacketDistributor.sendToServer((CustomPacketPayload)new SwitchVehicleWeaponMessage(index, -scroll, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        }
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.getItem() instanceof GunItem && ClientEventHandler.zoom) {
            GunData data = GunData.from(stack);
            if (data.canSwitchScope()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SwitchScopeMessage(scroll), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (data.canAdjustZoom() || stack.is((Item)ModItems.MINIGUN.get())) {
                PacketDistributor.sendToServer((CustomPacketPayload)new AdjustZoomFovMessage(scroll), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            event.setCanceled(true);
        }
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked")) {
            ClientEventHandler.droneFov = Mth.clamp((double)(ClientEventHandler.droneFov + 0.4 * scroll), (double)1.0, (double)6.0);
            event.setCanceled(true);
        }
        if ((looking = TraceTool.findLookingEntity((Entity)player, 6.0)) == null) {
            return;
        }
        if (looking instanceof MortarEntity && player.isShiftKeyDown()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new AdjustMortarAngleMessage(scroll), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.Key event) {
        if (ClickHandler.notInGame()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        int key = event.getKey();
        if (event.getAction() == 1) {
            ArmedVehicleEntity iVehicle;
            GunItem gunItem;
            Item item;
            if (player.hasEffect(ModMobEffects.SHOCK)) {
                return;
            }
            if (key == Minecraft.getInstance().options.keyJump.getKey().getValue()) {
                ClickHandler.handleDoubleJump((Player)player);
            }
            if (key == ModKeyMappings.CONFIG.getKey().getValue() && ModKeyMappings.CONFIG.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.IN_GAME)) {
                ClickHandler.handleConfigScreen((Player)player);
            }
            if (key == ModKeyMappings.RELOAD.getKey().getValue()) {
                ClientEventHandler.burstFireAmount = 0;
                isEditing = false;
                PacketDistributor.sendToServer((CustomPacketPayload)new ReloadMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (key == ModKeyMappings.FIRE_MODE.getKey().getValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FireModeMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (key == ModKeyMappings.INTERACT.getKey().getValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new InteractMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (key == ModKeyMappings.DISMOUNT.getKey().getValue()) {
                ClickHandler.handleDismountPress((Player)player);
            }
            if (key == ModKeyMappings.EDIT_MODE.getKey().getValue() && ClientEventHandler.burstFireAmount == 0 && (item = stack.getItem()) instanceof GunItem && (gunItem = (GunItem)item).isCustomizable(stack)) {
                ClientEventHandler.holdFire = false;
                if (!isEditing) {
                    player.playSound((SoundEvent)ModSounds.EDIT_MODE.get(), 1.0f, 1.0f);
                }
                boolean bl = isEditing = !isEditing;
            }
            if (key == ModKeyMappings.BREATH.getKey().getValue() && !ClientEventHandler.exhaustion && ClientEventHandler.zoom) {
                ClientEventHandler.breath = true;
            }
            if (isEditing) {
                item = stack.getItem();
                if (!(item instanceof GunItem)) {
                    return;
                }
                gunItem = (GunItem)item;
                if (ModKeyMappings.EDIT_GRIP.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.IN_GAME)) {
                    if (key == ModKeyMappings.EDIT_GRIP.getKey().getValue() && gunItem.hasCustomGrip(stack)) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new EditMessage(4), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        ClickHandler.editModelShake();
                    }
                } else if (key == ModKeyMappings.EDIT_SCOPE.getKey().getValue() && gunItem.hasCustomScope(stack)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new EditMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ClickHandler.editModelShake();
                } else if (key == ModKeyMappings.EDIT_BARREL.getKey().getValue() && gunItem.hasCustomBarrel(stack)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new EditMessage(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ClickHandler.editModelShake();
                } else if (key == ModKeyMappings.EDIT_MAGAZINE.getKey().getValue() && gunItem.hasCustomMagazine(stack)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new EditMessage(2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ClickHandler.editModelShake();
                } else if (key == ModKeyMappings.EDIT_STOCK.getKey().getValue() && gunItem.hasCustomStock(stack)) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new EditMessage(3), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ClickHandler.editModelShake();
                }
            }
            if (key == ModKeyMappings.SENSITIVITY_INCREASE.getKey().getValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SensitivityMessage(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (key == ModKeyMappings.SENSITIVITY_REDUCE.getKey().getValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SensitivityMessage(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (stack.getItem() instanceof GunItem || stack.is((Item)ModItems.MONITOR.get()) || (item = player.getVehicle()) instanceof ArmedVehicleEntity && (iVehicle = (ArmedVehicleEntity)item).isDriver((Player)player) || stack.is(Items.SPYGLASS) && player.isScoping() && player.getOffhandItem().is((Item)ModItems.FIRING_PARAMETERS.get())) {
                if (key == ModKeyMappings.FIRE.getKey().getValue()) {
                    ClickHandler.handleWeaponFirePress((Player)player, stack);
                }
                if (key == ModKeyMappings.HOLD_ZOOM.getKey().getValue()) {
                    ClickHandler.handleWeaponZoomPress((Player)player, stack);
                    switchZoom = false;
                    return;
                }
                if (key == ModKeyMappings.SWITCH_ZOOM.getKey().getValue()) {
                    ClickHandler.handleWeaponZoomPress((Player)player, stack);
                    boolean bl = switchZoom = !switchZoom;
                }
                if (event.getAction() == 0 && key == ModKeyMappings.BREATH.getKey().getValue()) {
                    ClientEventHandler.breath = false;
                }
            }
        } else {
            if (player.hasEffect(ModMobEffects.SHOCK)) {
                return;
            }
            if (key == ModKeyMappings.FIRE.getKey().getValue()) {
                ClickHandler.handleWeaponFireRelease();
            }
            if (key == ModKeyMappings.HOLD_ZOOM.getKey().getValue()) {
                ClickHandler.handleWeaponZoomRelease();
                return;
            }
            if (key == ModKeyMappings.SWITCH_ZOOM.getKey().getValue() && !switchZoom) {
                ClickHandler.handleWeaponZoomRelease();
            }
        }
    }

    public static void handleWeaponFirePress(Player player, ItemStack stack) {
        WeaponVehicleEntity iVehicle;
        Entity entity;
        isEditing = false;
        if (player.hasEffect(ModMobEffects.SHOCK)) {
            return;
        }
        if (stack.is(Items.SPYGLASS) && player.isScoping() && player.getOffhandItem().is((Item)ModItems.FIRING_PARAMETERS.get())) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetFiringParametersMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (stack.is((Item)ModItems.MONITOR.get())) {
            PacketDistributor.sendToServer((CustomPacketPayload)new DroneFireMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if ((entity = player.getVehicle()) instanceof WeaponVehicleEntity && (iVehicle = (WeaponVehicleEntity)entity).banHand(player)) {
            VehicleEntity pVehicle;
            Entity entity2 = player.getVehicle();
            if (entity2 instanceof VehicleEntity && iVehicle.hasWeapon((pVehicle = (VehicleEntity)entity2).getSeatIndex((Entity)player))) {
                ClientEventHandler.holdFireVehicle = true;
            }
            return;
        }
        if (stack.is((Item)ModItems.LUNGE_MINE.get())) {
            ClientEventHandler.holdFire = true;
        }
        if (!(!(stack.getItem() instanceof GunItem) || player.getVehicle() != null && player.getVehicle() instanceof CannonEntity || ClientEventHandler.clientTimer.getProgress() != 0L || ClickHandler.notInGame())) {
            GunData data = GunData.from(stack);
            if (!stack.is((Item)ModItems.BOCEK.get()) && !stack.is((Item)ModItems.AURELIA_SCEPTRE.get())) {
                player.playSound((SoundEvent)ModSounds.TRIGGER_CLICK.get(), 1.0f, 1.0f);
            } else {
                ClientEventHandler.bowPower = 0.0;
                ClientEventHandler.holdFire = true;
                player.setSprinting(false);
                if (data.ammo.get() > 0) {
                    return;
                }
            }
            if (!data.useBackpackAmmo() && data.ammo.get() <= 0 && data.reload.time() == 0) {
                if (((Boolean)ReloadConfig.LEFT_CLICK_RELOAD.get()).booleanValue()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ReloadMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ClientEventHandler.burstFireAmount = 0;
                }
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new FireKeyMessage(0, ClientEventHandler.bowPower, ClientEventHandler.zoom), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (!(data.reload.normal() || data.reload.empty() || data.reloading() || data.charging() || data.bolt.needed.get() || !(ClientEventHandler.drawTime < 0.01))) {
                    if (data.fireMode.get() == FireMode.BURST) {
                        if (ClientEventHandler.burstFireAmount == 0) {
                            ClientEventHandler.burstFireAmount = data.burstAmount();
                        }
                    } else {
                        ClientEventHandler.holdFire = true;
                        player.setSprinting(false);
                    }
                }
            }
        }
    }

    public static void handleWeaponFireRelease() {
        PacketDistributor.sendToServer((CustomPacketPayload)new FireKeyMessage(1, ClientEventHandler.bowPower, ClientEventHandler.zoom), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ClientEventHandler.bowPull = false;
        ClientEventHandler.holdFire = false;
        ClientEventHandler.holdFireVehicle = false;
        isEditing = false;
        ClientEventHandler.customRpm = 0;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.is((Item)ModItems.BOCEK.get())) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ReloadMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void handleWeaponZoomPress(Player player, ItemStack stack) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ZoomMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        isEditing = false;
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity) {
            WeaponVehicleEntity iVehicle;
            VehicleEntity pVehicle = (VehicleEntity)entity;
            entity = player.getVehicle();
            if (entity instanceof WeaponVehicleEntity && (iVehicle = (WeaponVehicleEntity)entity).hasWeapon(pVehicle.getSeatIndex((Entity)player)) && iVehicle.banHand(player)) {
                ClientEventHandler.zoomVehicle = true;
                return;
            }
        }
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        ClientEventHandler.zoom = true;
        short level = data.perk.getLevel(ModPerks.INTELLIGENT_CHIP);
        if (level > 0 && ClientEventHandler.entity == null) {
            ClientEventHandler.entity = SeekTool.seekLivingEntity((Entity)player, player.level(), 32 + 8 * (level - 1), 20.0);
        }
    }

    public static void handleWeaponZoomRelease() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ZoomMessage(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ClientEventHandler.zoom = false;
        ClientEventHandler.zoomVehicle = false;
        ClientEventHandler.entity = null;
        ClientEventHandler.breath = false;
    }

    private static void editModelShake() {
        ClientEventHandler.movePosY = -0.8;
        ClientEventHandler.fireRotTimer = 0.4;
    }

    private static void handleDoubleJump(Player player) {
        Level level = player.level();
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        if (!level.isLoaded(player.blockPosition())) {
            return;
        }
        if (ClientEventHandler.canDoubleJump) {
            player.setDeltaMovement(new Vec3(player.getLookAngle().x, 0.8, player.getLookAngle().z));
            level.playLocalSound(x, y, z, (SoundEvent)ModSounds.DOUBLE_JUMP.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            PacketDistributor.sendToServer((CustomPacketPayload)new DoubleJumpMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ClientEventHandler.canDoubleJump = false;
        }
    }

    private static void handleConfigScreen(Player player) {
        if (ModList.get().isLoaded("cloth_config")) {
            CompatHolder.hasMod("cloth_config", () -> Minecraft.getInstance().setScreen(ClothConfigHelper.getConfigScreen(null)));
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.no_cloth_config").withStyle(ChatFormatting.RED), true);
        }
    }

    private static void handleDismountPress(Player player) {
        Entity vehicle = player.getVehicle();
        if (!(vehicle instanceof VehicleEntity)) {
            return;
        }
        if ((!vehicle.onGround() || vehicle.getDeltaMovement().length() >= 0.1) && ClientEventHandler.dismountCountdown <= 0) {
            player.displayClientMessage((Component)Component.translatable((String)"mount.onboard", (Object[])new Object[]{ModKeyMappings.DISMOUNT.getTranslatedKeyMessage()}), true);
            ClientEventHandler.dismountCountdown = 20;
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new PlayerStopRidingMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

