/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.model.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.LaserTowerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

public class LaserTowerModel
extends GeoModel<LaserTowerEntity> {
    public ResourceLocation getAnimationResource(LaserTowerEntity entity) {
        return Mod.loc("animations/laser_tower.animation.json");
    }

    public ResourceLocation getModelResource(LaserTowerEntity entity) {
        LocalPlayer player = Minecraft.getInstance().player;
        int distance = 0;
        if (player != null) {
            distance = (int)player.position().distanceTo(entity.position());
        }
        if (distance < 24 || player.isScoping()) {
            return Mod.loc("geo/laser_tower.geo.json");
        }
        if (distance < 48) {
            return Mod.loc("geo/laser_tower.lod1.geo.json");
        }
        return Mod.loc("geo/laser_tower.lod2.geo.json");
    }

    public ResourceLocation getTextureResource(LaserTowerEntity entity) {
        return Mod.loc("textures/entity/laser_tower.png");
    }

    public void setCustomAnimations(LaserTowerEntity animatable, long instanceId, AnimationState<LaserTowerEntity> animationState) {
        GeoBone laser = this.getAnimationProcessor().getBone("laser");
        laser.setScaleZ(10.0f * ((Float)animatable.getEntityData().get(LaserTowerEntity.LASER_LENGTH)).floatValue());
    }
}

