/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.model.item;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.function.DoubleSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.model.GeoModel;

public abstract class CustomGunModel<T extends GunItem>
extends GeoModel<T> {
    public ResourceLocation getLODModelResource(T animatable) {
        return this.getModelResource((GeoAnimatable)animatable, null);
    }

    public ResourceLocation getLODTextureResource(T animatable) {
        return this.getTextureResource((GeoAnimatable)animatable, null);
    }

    public void applyMolangQueries(AnimationState<T> animationState, double animTime) {
        LocalPlayer player;
        Minecraft mc = Minecraft.getInstance();
        CustomGunModel.set("query.life_time", () -> animTime / 20.0);
        if (mc.level != null) {
            CustomGunModel.set("query.actor_count", () -> ((ClientLevel)mc.level).getEntityCount());
            CustomGunModel.set("query.time_of_day", () -> (float)mc.level.getDayTime() / 24000.0f);
            CustomGunModel.set("query.moon_phase", () -> ((ClientLevel)mc.level).getMoonPhase());
        }
        if ((player = mc.player) == null) {
            this.resetQueryValue();
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            this.resetQueryValue();
            return;
        }
        ItemStack item = (ItemStack)animationState.getData(DataTickets.ITEMSTACK);
        if (item == null || GeoItem.getId((ItemStack)item) != GeoItem.getId((ItemStack)stack)) {
            this.resetQueryValue();
            return;
        }
        if (animationState.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            this.resetQueryValue();
            return;
        }
        GunData data = GunData.from(stack);
        CustomGunModel.set("query.sbw_is_empty", () -> data.isEmpty.get() ? 1.0 : 0.0);
        CustomGunModel.set("query.sbw_system_time", System::currentTimeMillis);
    }

    private static void set(String key, DoubleSupplier value) {
        MathParser.setVariable((String)key, (DoubleSupplier)value);
    }

    private void resetQueryValue() {
        CustomGunModel.set("query.sbw_is_empty", () -> 0.0);
        CustomGunModel.set("query.sbw_system_time", () -> 0.0);
    }

    public boolean shouldCancelRender(ItemStack stack, AnimationState<T> animationState) {
        if (!(stack.getItem() instanceof GunItem)) {
            return true;
        }
        ItemStack item = (ItemStack)animationState.getData(DataTickets.ITEMSTACK);
        if (item == null || GeoItem.getId((ItemStack)item) != GeoItem.getId((ItemStack)stack)) {
            return true;
        }
        return animationState.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
    }
}

