/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.model.item;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.model.item.CustomGunModel;
import com.atsuishio.superbwarfare.client.overlay.CrossHairOverlay;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.machinegun.MinigunItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;

public class MinigunItemModel
extends CustomGunModel<MinigunItem> {
    private static float rotZ = 0.0f;

    public ResourceLocation getAnimationResource(MinigunItem animatable) {
        return Mod.loc("animations/minigun.animation.json");
    }

    public ResourceLocation getModelResource(MinigunItem animatable) {
        return Mod.loc("geo/minigun.geo.json");
    }

    public ResourceLocation getTextureResource(MinigunItem animatable) {
        return Mod.loc("textures/item/minigun.png");
    }

    @Override
    public ResourceLocation getLODModelResource(MinigunItem animatable) {
        return Mod.loc("geo/lod/minigun.geo.json");
    }

    @Override
    public ResourceLocation getLODTextureResource(MinigunItem animatable) {
        return Mod.loc("textures/item/lod/minigun.png");
    }

    public void setCustomAnimations(MinigunItem animatable, long instanceId, AnimationState<MinigunItem> animationState) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (this.shouldCancelRender(stack, animationState)) {
            return;
        }
        GeoBone gun = this.getAnimationProcessor().getBone("barrel");
        GeoBone shen = this.getAnimationProcessor().getBone("shen");
        float times = 0.6f * (float)Math.min((double)Minecraft.getInstance().getTimer().getRealtimeDeltaTicks(), 0.8);
        double fpz = ClientEventHandler.firePosZ * 13.0 * (double)times;
        double fp = ClientEventHandler.firePos;
        double fr = ClientEventHandler.fireRot;
        GunData data = GunData.from(stack);
        int rpm = data.rpm();
        float heat = (float)data.heat.get();
        for (int i = 1; i <= 6; ++i) {
            GeoBone bone = this.getAnimationProcessor().getBone("barrel" + i + "_illuminated");
            bone.setScaleZ(heat / 2.0f);
        }
        gun.setRotZ(rotZ += times * -0.14f * ((float)rpm / 1200.0f) * (float)ClientEventHandler.shootDelay);
        shen.setPosX((float)(0.75 * ClientEventHandler.recoilHorizon * fpz * fp));
        shen.setPosY((float)((double)-0.03f * fp - (double)0.06f * fr));
        shen.setPosZ((float)(0.625 * fp + (double)0.34f * fr + 1.15 * fpz));
        shen.setRotX((float)((double)0.02f * fp + (double)0.02f * fr + (double)0.02f * fpz));
        shen.setRotY((float)((double)0.02f * ClientEventHandler.recoilHorizon * fpz));
        shen.setRotZ((float)(((double)0.02f + 0.02 * fr) * ClientEventHandler.recoilHorizon));
        CrossHairOverlay.gunRot = shen.getRotZ();
        ClientEventHandler.gunRootMove(this.getAnimationProcessor());
        GeoBone camera = this.getAnimationProcessor().getBone("camera");
        ClientEventHandler.handleReloadShake(57.295776f * camera.getRotX(), 57.295776f * camera.getRotY(), 57.295776f * camera.getRotZ());
    }
}

