/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.ClickHandler;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.entity.vehicle.Ah6Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.HelicopterEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class HelicopterHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("helicopter_hud");
    private static float scopeScale = 1.0f;
    private static float lerpVy = 1.0f;
    private static float lerpPower = 1.0f;

    /*
     * Enabled aggressive block sorting
     */
    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        PoseStack poseStack = guiGraphics.pose();
        if (player == null) {
            return;
        }
        if (ClickHandler.isEditing) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof HelicopterEntity) {
            HelicopterEntity iHelicopterEntity = (HelicopterEntity)entity;
            entity = player.getVehicle();
            if (entity instanceof MobileVehicleEntity) {
                MobileVehicleEntity mobileVehicle = (MobileVehicleEntity)entity;
                if (iHelicopterEntity.isDriver((Player)player) && (entity = player.getVehicle()) instanceof WeaponVehicleEntity) {
                    WeaponVehicleEntity weaponVehicle = (WeaponVehicleEntity)entity;
                    poseStack.pushPose();
                    poseStack.translate(-6.0 * ClientEventHandler.turnRot[1], -6.0 * ClientEventHandler.turnRot[0], 0.0);
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.enableBlend();
                    RenderSystem.setShader(GameRenderer::getPositionTexShader);
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
                    scopeScale = Mth.lerp((float)partialTick, (float)scopeScale, (float)1.0f);
                    float f = Math.min((int)w, (int)h);
                    float f1 = Math.min((float)((float)w / f), (float)((float)h / f)) * scopeScale;
                    float i = Mth.floor((float)(f * f1));
                    float j = Mth.floor((float)(f * f1));
                    float k = ((float)w - i) / 2.0f;
                    float l = ((float)h - j) / 2.0f;
                    if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/heli_base.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                        HelicopterHudOverlay.renderDriverAngle(guiGraphics, (Player)player, mobileVehicle, k, l, i, j, partialTick);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/compass.png"), (float)w / 2.0f - 128.0f, 6.0f, 128.0f + 1.4222223f * mobileVehicle.getYRot(), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f);
                        poseStack.pushPose();
                        poseStack.rotateAround(Axis.ZP.rotationDegrees(-iHelicopterEntity.getRotZ(partialTick)), (float)w / 2.0f, (float)h / 2.0f, 0.0f);
                        float pitch = iHelicopterEntity.getRotX(partialTick);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/heli_line.png"), (float)w / 2.0f - 128.0f, (float)h / 2.0f - 512.0f - 5.475f * pitch, 0.0f, 0.0f, 256.0f, 1024.0f, 256.0f, 1024.0f);
                        poseStack.popPose();
                        poseStack.pushPose();
                        poseStack.rotateAround(Axis.ZP.rotationDegrees(iHelicopterEntity.getRotZ(partialTick)), (float)w / 2.0f, (float)h / 2.0f - 56.0f, 0.0f);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/roll_ind.png"), (float)w / 2.0f - 8.0f, (float)h / 2.0f - 88.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
                        poseStack.popPose();
                        guiGraphics.blit(Mod.loc("textures/screens/helicopter/heli_power_ruler.png"), w / 2 + 100, h / 2 - 64, 0.0f, 0.0f, 64, 128, 64, 128);
                        double height = mobileVehicle.position().distanceTo(Vec3.atLowerCornerOf((Vec3i)mobileVehicle.level().clip(new ClipContext(mobileVehicle.position(), mobileVehicle.position().add(new Vec3(0.0, -1.0, 0.0).scale(100.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)mobileVehicle)).getBlockPos()));
                        double blockInWay = mobileVehicle.position().distanceTo(Vec3.atLowerCornerOf((Vec3i)mobileVehicle.level().clip(new ClipContext(mobileVehicle.position(), mobileVehicle.position().add(new Vec3(mobileVehicle.getDeltaMovement().x, mobileVehicle.getDeltaMovement().y + 0.06, mobileVehicle.getDeltaMovement().z).normalize().scale(100.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)mobileVehicle)).getBlockPos()));
                        float power = iHelicopterEntity.getPower();
                        lerpPower = Mth.lerp((float)(0.001f * partialTick), (float)lerpPower, (float)power);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/heli_power.png"), (float)w / 2.0f + 130.0f, (float)h / 2.0f - 64.0f + 124.0f - power * 980.0f, 0.0f, 0.0f, 4.0f, power * 980.0f, 4.0f, power * 980.0f);
                        lerpVy = (float)Mth.lerp((double)(0.021f * partialTick), (double)lerpVy, (double)mobileVehicle.getDeltaMovement().y());
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/heli_vy_move.png"), (float)w / 2.0f + 138.0f, (float)h / 2.0f - 3.0f - Math.max((float)(lerpVy * 20.0f), (float)-24.0f) * 2.5f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(lerpVy * 20.0f, "m/s")), w / 2 + 146, (int)((double)(h / 2 - 3) - (double)Math.max((float)(lerpVy * 20.0f), (float)-24.0f) * 2.5), lerpVy * 20.0f < -24.0f || (lerpVy * 20.0f < -10.0f || lerpVy * 20.0f < -1.0f && HelicopterHudOverlay.length(mobileVehicle.getDeltaMovement().x, mobileVehicle.getDeltaMovement().y, mobileVehicle.getDeltaMovement().z) * 72.0 > 100.0) && height < 36.0 || HelicopterHudOverlay.length(mobileVehicle.getDeltaMovement().x, mobileVehicle.getDeltaMovement().y, mobileVehicle.getDeltaMovement().z) * 72.0 > 40.0 && blockInWay < 72.0 ? -65536 : 0x66FF00, false);
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(mobileVehicle.getY())), w / 2 + 104, h / 2, 0x66FF00, false);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/speed_frame.png"), (float)w / 2.0f - 144.0f, (float)h / 2.0f - 6.0f, 0.0f, 0.0f, 50.0f, 18.0f, 50.0f, 18.0f);
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(HelicopterHudOverlay.length(mobileVehicle.getDeltaMovement().x, mobileVehicle.getDeltaMovement().y, mobileVehicle.getDeltaMovement().z) * 72.0, "km/h")), w / 2 - 140, h / 2, 0x66FF00, false);
                        if (mobileVehicle instanceof Ah6Entity) {
                            Ah6Entity ah6Entity = (Ah6Entity)mobileVehicle;
                            if (weaponVehicle.getWeaponIndex(0) == 0) {
                                double heat = 1.0f - (float)((Integer)ah6Entity.getEntityData().get(MobileVehicleEntity.HEAT)).intValue() / 100.0f;
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("20MM CANNON " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Player)player) ? "\u221e" : Integer.valueOf(iHelicopterEntity.getAmmoCount((Player)player))))), w / 2 - 160, h / 2 - 60, Mth.hsvToRgb((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
                            } else {
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("70MM ROCKET " + iHelicopterEntity.getAmmoCount((Player)player))), w / 2 - 160, h / 2 - 60, 0x66FF00, false);
                            }
                        }
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("FLARE " + iHelicopterEntity.getDecoy())), w / 2 - 160, h / 2 - 50, 0x66FF00, false);
                        if (lerpVy * 20.0f < -24.0f) {
                            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"SINK RATE\uff0cPULL UP!"), w / 2 - 53, h / 2 + 24, -65536, false);
                        } else if ((lerpVy * 20.0f < -10.0f || lerpVy * 20.0f < -1.0f && HelicopterHudOverlay.length(mobileVehicle.getDeltaMovement().x, mobileVehicle.getDeltaMovement().y, mobileVehicle.getDeltaMovement().z) * 72.0 > 100.0) && height < 36.0 || HelicopterHudOverlay.length(mobileVehicle.getDeltaMovement().x, mobileVehicle.getDeltaMovement().y, mobileVehicle.getDeltaMovement().z) * 72.0 > 40.0 && blockInWay < 72.0) {
                            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"TERRAIN TERRAIN"), w / 2 - 42, h / 2 + 24, -65536, false);
                        }
                        if ((double)mobileVehicle.getEnergy() < 0.02 * (double)mobileVehicle.getMaxEnergy()) {
                            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"NO POWER!"), w / 2 - 144, h / 2 + 14, -65536, false);
                        } else if ((double)mobileVehicle.getEnergy() < 0.2 * (double)mobileVehicle.getMaxEnergy()) {
                            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"LOW POWER"), w / 2 - 144, h / 2 + 14, 16739072, false);
                        }
                    }
                    float fovAdjust2 = (float)((Integer)Minecraft.getInstance().options.fov().get() / 30) - 1.0f;
                    double zoom = 2.88 + 0.06 * (double)fovAdjust2;
                    Vec3 lookVec = new Vec3(camera.getLookVector());
                    Vec3 pos = iHelicopterEntity.shootPos(partialTick).add(iHelicopterEntity.shootVec(partialTick).scale(192.0));
                    Vec3 lookAngle = lookVec.normalize().scale(pos.distanceTo(cameraPos) * (1.0 - 1.0 / zoom));
                    Vec3 cPos = cameraPos.add(lookAngle);
                    Vec3 p = RenderHelper.worldToScreen(iHelicopterEntity.shootPos(partialTick).add(mobileVehicle.getViewVector(partialTick).scale(192.0)), ClientEventHandler.zoomVehicle ? cPos : cameraPos);
                    if (p != null) {
                        poseStack.pushPose();
                        float x = (float)p.x;
                        float y = (float)p.y;
                        if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
                            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/crosshair_ind.png"), x - 8.0f, y - 8.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
                            HelicopterHudOverlay.renderKillIndicator(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                        } else if (mc.options.getCameraType() != CameraType.FIRST_PERSON) {
                            poseStack.pushPose();
                            poseStack.rotateAround(Axis.ZP.rotationDegrees(iHelicopterEntity.getRotZ(partialTick)), x, y, 0.0f);
                            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/drone.png"), x - 8.0f, y - 8.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
                            HelicopterHudOverlay.renderKillIndicator(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                            poseStack.pushPose();
                            poseStack.translate(x, y, 0.0f);
                            poseStack.scale(0.75f, 0.75f, 1.0f);
                            if (mobileVehicle instanceof Ah6Entity) {
                                Ah6Entity ah6Entity = (Ah6Entity)mobileVehicle;
                                if (weaponVehicle.getWeaponIndex(0) == 0) {
                                    double heat = (float)((Integer)ah6Entity.getEntityData().get(MobileVehicleEntity.HEAT)).intValue() / 100.0f;
                                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("20MM CANNON " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Player)player) ? "\u221e" : Integer.valueOf(iHelicopterEntity.getAmmoCount((Player)player))))), 25, -9, Mth.hsvToRgb((float)0.0f, (float)((float)heat), (float)1.0f), false);
                                } else {
                                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("70MM ROCKET " + iHelicopterEntity.getAmmoCount((Player)player))), 25, -9, -1, false);
                                }
                            }
                            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("FLARE " + iHelicopterEntity.getDecoy())), 25, 1, -1, false);
                            poseStack.popPose();
                            poseStack.popPose();
                        }
                        poseStack.popPose();
                    }
                    poseStack.popPose();
                    return;
                }
            }
        }
        scopeScale = 0.7f;
    }

    private static void renderKillIndicator(GuiGraphics guiGraphics, float posX, float posY) {
        VehicleHudOverlay.renderKillIndicator3P(guiGraphics, posX, posY);
    }

    private static void renderDriverAngle(GuiGraphics guiGraphics, Player player, Entity heli, float k, float l, float i, float j, float ticks) {
        float diffY = Mth.wrapDegrees((float)(Mth.lerp((float)ticks, (float)player.yHeadRotO, (float)player.getYHeadRot()) - Mth.lerp((float)ticks, (float)heli.yRotO, (float)heli.getYRot()))) * 0.35f;
        float diffX = Mth.wrapDegrees((float)(Mth.lerp((float)ticks, (float)player.xRotO, (float)player.getXRot()) - Mth.lerp((float)ticks, (float)heli.xRotO, (float)heli.getXRot()))) * 0.072f;
        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/heli_driver_angle.png"), k + diffY, l + diffX, 0.0f, 0.0f, i, j, i, j);
    }

    public static double length(double x, double y, double z) {
        return Math.sqrt((double)(x * x + y * y + z * z));
    }
}

