/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.ClickHandler;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JavelinHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("javelin_hud");
    private static final ResourceLocation FRAME = Mod.loc("textures/screens/frame/frame.png");
    private static final ResourceLocation FRAME_TARGET = Mod.loc("textures/screens/frame/frame_target.png");
    private static final ResourceLocation FRAME_LOCK = Mod.loc("textures/screens/frame/frame_lock.png");
    private static float scopeScale = 1.0f;

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        PoseStack poseStack = guiGraphics.pose();
        if (player != null) {
            ArmedVehicleEntity iArmedVehicle;
            ItemStack stack = player.getMainHandItem();
            if (ClickHandler.isEditing) {
                return;
            }
            Entity entity = player.getVehicle();
            if (entity instanceof ArmedVehicleEntity && (iArmedVehicle = (ArmedVehicleEntity)entity).banHand((Player)player)) {
                return;
            }
            if (stack.getItem() == ModItems.JAVELIN.get() && ClientEventHandler.zoomPos > 0.8 && Minecraft.getInstance().options.getCameraType().isFirstPerson() && ClientEventHandler.zoom) {
                GunData data = GunData.from(stack);
                CompoundTag tag = data.tag();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float deltaFrame = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
                float moveX = (float)(-32.0 * ClientEventHandler.turnRot[1] - (double)(player.isSprinting() ? 100 : 67) * ClientEventHandler.movePosX + 3.0 * ClientEventHandler.cameraRot[2]);
                float moveY = (float)(-32.0 * ClientEventHandler.turnRot[0] + (double)(100.0f * (float)ClientEventHandler.velocityY) - (double)(player.isSprinting() ? 100 : 67) * ClientEventHandler.movePosY - 12.0 * ClientEventHandler.firePos + 3.0 * ClientEventHandler.cameraRot[1]);
                scopeScale = (float)Mth.lerp((double)(0.5f * deltaFrame), (double)scopeScale, (double)((double)1.35f + (double)0.2f * ClientEventHandler.firePos));
                float f = Math.min(w, h);
                float f1 = Math.min((float)w / f, (float)h / f) * scopeScale;
                float i = Mth.floor((float)(f * f1));
                float j = Mth.floor((float)(f * f1));
                float k = ((float)w - i) / 2.0f + moveX;
                float l = ((float)h - j) / 2.0f + moveY;
                float i1 = k + i;
                float j1 = l + j;
                RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/javelin/javelin_hud.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                RenderHelper.preciseBlit(guiGraphics, Mod.loc(tag.getBoolean("TopMode") ? "textures/screens/javelin/top.png" : "textures/screens/javelin/dir.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                RenderHelper.preciseBlit(guiGraphics, Mod.loc(data.hasEnoughAmmoToShoot((Player)player) ? "textures/screens/javelin/missile_green.png" : "textures/screens/javelin/missile_red.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                if (tag.getInt("SeekTime") > 1 && tag.getInt("SeekTime") < 20) {
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/javelin/seek.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                }
                guiGraphics.fill(RenderType.guiOverlay(), 0, (int)l, (int)k + 3, (int)j1, -90, -16777216);
                guiGraphics.fill(RenderType.guiOverlay(), (int)i1, (int)l, w, (int)j1, -90, -16777216);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float fovAdjust = (float)((Integer)Minecraft.getInstance().options.fov().get()).intValue() / 80.0f;
                Entity targetEntity = EntityFindUtil.findEntity(player.level(), tag.getString("TargetEntity"));
                List<Entity> entities = SeekTool.seekLivingEntities((Entity)player, player.level(), 512.0, 8.0f * fovAdjust);
                Entity naerestEntity = SeekTool.seekLivingEntity((Entity)player, player.level(), 512.0, 6.0);
                float fovAdjust2 = (float)((Integer)Minecraft.getInstance().options.fov().get() / 30) - 1.0f;
                double zoom = (double)((Integer)Minecraft.getInstance().options.fov().get()).intValue() / ClientEventHandler.fov + 0.5 * (double)fovAdjust2;
                Vec3 playerVec = new Vec3(Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)player.xo, (double)player.getX()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)player.zo, (double)player.getZ()));
                if (tag.getInt("GuideType") == 0) {
                    for (Entity e : entities) {
                        Vec3 lookAngle;
                        Vec3 cPos;
                        Vec3 pos = new Vec3(Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)e.xo, (double)e.getX()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)(e.yo + (double)e.getEyeHeight()), (double)e.getEyeY()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)e.zo, (double)e.getZ()));
                        Vec3 point = RenderHelper.worldToScreen(pos, cPos = playerVec.add(lookAngle = player.getLookAngle().normalize().scale(pos.distanceTo(playerVec) * (1.0 - 1.0 / zoom))));
                        if (point == null) {
                            return;
                        }
                        boolean lockOn = tag.getInt("SeekTime") > 20 && e == targetEntity;
                        boolean nearest = e == naerestEntity;
                        poseStack.pushPose();
                        float x = (float)point.x;
                        float y = (float)point.y;
                        RenderHelper.preciseBlit(guiGraphics, lockOn ? FRAME_LOCK : (nearest ? FRAME_TARGET : FRAME), x - 12.0f, y - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                        poseStack.popPose();
                    }
                } else {
                    Vec3 pos = new Vec3(tag.getDouble("TargetPosX"), tag.getDouble("TargetPosY"), tag.getDouble("TargetPosZ"));
                    Vec3 lookAngle = player.getLookAngle().normalize().scale(pos.distanceTo(playerVec) * (1.0 - 1.0 / zoom));
                    boolean lockOn = tag.getInt("SeekTime") > 20;
                    Vec3 cPos = playerVec.add(lookAngle);
                    Vec3 point = RenderHelper.worldToScreen(pos, cPos);
                    if (point == null) {
                        return;
                    }
                    poseStack.pushPose();
                    float x = (float)point.x;
                    float y = (float)point.y;
                    RenderHelper.preciseBlit(guiGraphics, lockOn ? FRAME_LOCK : FRAME_TARGET, x - 12.0f, y - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                    poseStack.popPose();
                }
            } else {
                scopeScale = 1.0f;
            }
        }
    }
}

