/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.CrossHairOverlay;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.entity.vehicle.SpeedboatEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AircraftEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.EnergyVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.HeliRocketWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.LaserWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SwarmDroneWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.animation.AnimationCurves;
import com.atsuishio.superbwarfare.tools.animation.AnimationTimer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
public class VehicleHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("vehicle_hud");
    private static float scopeScale = 1.0f;
    private static final ResourceLocation FRAME = Mod.loc("textures/screens/land/tv_frame.png");
    private static final ResourceLocation ARMOR = Mod.loc("textures/screens/armor.png");
    private static final ResourceLocation ENERGY = Mod.loc("textures/screens/energy.png");
    private static final ResourceLocation HEALTH = Mod.loc("textures/screens/armor_value.png");
    private static final ResourceLocation HEALTH_FRAME = Mod.loc("textures/screens/armor_value_frame.png");
    private static final ResourceLocation DRIVER = Mod.loc("textures/screens/driver.png");
    private static final ResourceLocation PASSENGER = Mod.loc("textures/screens/passenger.png");
    private static final ResourceLocation SELECTED = Mod.loc("textures/screens/vehicle_weapon/selected.png");
    private static final ResourceLocation NUMBER = Mod.loc("textures/screens/vehicle_weapon/number.png");
    private static final ResourceLocation GEAR = Mod.loc("textures/screens/aircraft/gear.png");
    public static final int ANIMATION_TIME = 300;
    private static final AnimationTimer[] weaponSlotsTimer = AnimationTimer.createTimers(9, 300L, AnimationCurves.EASE_OUT_CIRC);
    private static boolean wasRenderingWeapons = false;
    private static int oldWeaponIndex = 0;
    private static int oldRenderWeaponIndex = 0;
    private static final AnimationTimer weaponIndexUpdateTimer = new AnimationTimer(300L).animation(AnimationCurves.EASE_OUT_CIRC);

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        if (!VehicleHudOverlay.shouldRenderHud((Player)player)) {
            wasRenderingWeapons = false;
            return;
        }
        Entity vehicle = player.getVehicle();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        VehicleHudOverlay.renderLandArmorHud(guiGraphics, deltaTracker, w, h);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int compatHeight = VehicleHudOverlay.getArmorPlateCompatHeight((Player)player);
        if (vehicle instanceof EnergyVehicleEntity) {
            EnergyVehicleEntity energyVehicleEntity = (EnergyVehicleEntity)vehicle;
            float energy = energyVehicleEntity.getEnergy();
            float maxEnergy = energyVehicleEntity.getMaxEnergy();
            RenderHelper.preciseBlit(guiGraphics, ENERGY, 10.0f, h - 22 - compatHeight, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
            RenderHelper.preciseBlit(guiGraphics, HEALTH_FRAME, 20.0f, h - 21 - compatHeight, 100.0f, 0.0f, 0.0f, 60.0f, 6.0f, 60.0f, 6.0f);
            RenderHelper.preciseBlit(guiGraphics, HEALTH, 20.0f, h - 21 - compatHeight, 100.0f, 0.0f, 0.0f, (int)(60.0f * energy / maxEnergy), 6.0f, 60.0f, 6.0f);
        }
        if (vehicle instanceof VehicleEntity) {
            VehicleEntity pVehicle = (VehicleEntity)vehicle;
            float health = pVehicle.getHealth();
            float maxHealth = pVehicle.getMaxHealth();
            RenderHelper.preciseBlit(guiGraphics, ARMOR, 10.0f, h - 13 - compatHeight, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
            RenderHelper.preciseBlit(guiGraphics, HEALTH_FRAME, 20.0f, h - 12 - compatHeight, 100.0f, 0.0f, 0.0f, 60.0f, 6.0f, 60.0f, 6.0f);
            RenderHelper.preciseBlit(guiGraphics, HEALTH, 20.0f, h - 12 - compatHeight, 100.0f, 0.0f, 0.0f, (int)(60.0f * health / maxHealth), 6.0f, 60.0f, 6.0f);
            VehicleHudOverlay.renderWeaponInfo(guiGraphics, pVehicle, w, h);
            VehicleHudOverlay.renderPassengerInfo(guiGraphics, pVehicle, w, h);
        }
        if (vehicle instanceof AircraftEntity) {
            AircraftEntity aircraftEntity = (AircraftEntity)vehicle;
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float angle = aircraftEntity.gearRot(deltaTracker.getGameTimeDeltaPartialTick(true)).floatValue();
            poseStack.pushPose();
            poseStack.rotateAround(Axis.ZP.rotationDegrees(-90.0f + angle), 102.0f, (float)(h - 20), 0.0f);
            RenderHelper.preciseBlit(guiGraphics, GEAR, 86.0f, h - 36, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private static boolean shouldRenderHud(Player player) {
        if (player == null) {
            return false;
        }
        return !player.isSpectator() && player.getVehicle() != null && player.getVehicle() instanceof VehicleEntity;
    }

    private static int getArmorPlateCompatHeight(Player player) {
        ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (stack == ItemStack.EMPTY) {
            return 0;
        }
        if (!NBTTool.getTag(stack).contains("ArmorPlate")) {
            return 0;
        }
        if (!((Boolean)DisplayConfig.ARMOR_PLATE_HUD.get()).booleanValue()) {
            return 0;
        }
        return 9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void renderLandArmorHud(GuiGraphics guiGraphics, DeltaTracker deltaTracker, int w, int h) {
        LandArmorEntity iLand;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        PoseStack poseStack = guiGraphics.pose();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        assert (player != null);
        Entity entity = player.getVehicle();
        if (entity instanceof LandArmorEntity && (iLand = (LandArmorEntity)entity).isDriver((Player)player) && iLand instanceof WeaponVehicleEntity && iLand instanceof MobileVehicleEntity) {
            MobileVehicleEntity mobileVehicle = (MobileVehicleEntity)((Object)iLand);
            if (!(player.getVehicle() instanceof SpeedboatEntity)) {
                Vec3 p;
                poseStack.pushPose();
                poseStack.translate(0.0, 0.0 - 0.3 * ClientEventHandler.shakeTime + (double)(3.0f * ClientEventHandler.cameraRoll), 0.0);
                poseStack.rotateAround(Axis.ZP.rotationDegrees(-0.3f * ClientEventHandler.cameraRoll), (float)w / 2.0f, (float)h / 2.0f, 0.0f);
                poseStack.translate(0.2 * ClientEventHandler.shakeTime + (double)(5.0f * ClientEventHandler.cameraRoll), 0.0 - 0.3 * ClientEventHandler.shakeTime + (double)(5.0f * ClientEventHandler.cameraRoll), 0.0);
                poseStack.rotateAround(Axis.ZP.rotationDegrees(-0.5f * ClientEventHandler.cameraRoll), (float)w / 2.0f, (float)h / 2.0f, 0.0f);
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
                float scale = scopeScale = Mth.lerp((float)partialTick, (float)scopeScale, (float)1.0f);
                if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle) {
                    int addW = w / h * 48;
                    int addH = w / h * 27;
                    RenderHelper.preciseBlit(guiGraphics, FRAME, (float)(-addW) / 2.0f, (float)(-addH) / 2.0f, 10.0f, 0.0f, 0.0f, w + addW, h + addH, w + addW, h + addH);
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/line.png"), (float)w / 2.0f - 64.0f, h - 56, 0.0f, 0.0f, 128.0f, 1.0f, 128.0f, 1.0f);
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/line.png"), (float)w / 2.0f + 112.0f, h - 71, 0.0f, 0.0f, 1.0f, 16.0f, 1.0f, 16.0f);
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/compass.png"), (float)w / 2.0f - 128.0f, 10.0f, 128.0f + 1.4222223f * player.getYRot(), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f);
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/roll_ind.png"), (float)w / 2.0f - 8.0f, 30.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
                    poseStack.pushPose();
                    poseStack.rotateAround(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)iLand.turretYRotO(), (float)iLand.turretYRot())), (float)w / 2.0f + 112.0f, (float)(h - 56), 0.0f);
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/body.png"), (float)w / 2.0f + 96.0f, h - 72, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f);
                    poseStack.popPose();
                    guiGraphics.drawString(mc.font, (Component)Component.literal((String)FormatTool.format0D(mobileVehicle.getDeltaMovement().dot(mobileVehicle.getViewVector(partialTick)) * 72.0, " km/h")), w / 2 + 160, h / 2 - 48, 0x66FF00, false);
                    if ((double)mobileVehicle.getEnergy() < 0.02 * (double)mobileVehicle.getMaxEnergy()) {
                        guiGraphics.drawString(mc.font, (Component)Component.literal((String)"NO POWER!"), w / 2 - 144, h / 2 + 14, -65536, false);
                    } else if ((double)mobileVehicle.getEnergy() < 0.2 * (double)mobileVehicle.getMaxEnergy()) {
                        guiGraphics.drawString(mc.font, (Component)Component.literal((String)"LOW POWER"), w / 2 - 144, h / 2 + 14, 16739072, false);
                    }
                    boolean lookAtEntity = false;
                    BlockHitResult result = player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(player.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                    Vec3 hitPos = result.getLocation();
                    double blockRange = player.getEyePosition(1.0f).distanceTo(hitPos);
                    double entityRange = 0.0;
                    Entity lookingEntity = TraceTool.camerafFindLookingEntity((Player)player, cameraPos, 512.0, deltaTracker.getRealtimeDeltaTicks());
                    if (lookingEntity != null) {
                        lookAtEntity = true;
                        entityRange = player.distanceTo(lookingEntity);
                    }
                    if (lookAtEntity) {
                        guiGraphics.drawString(mc.font, (Component)Component.literal((String)FormatTool.format1D(entityRange, "m")), w / 2 - 6, h - 53, 0x66FF00, false);
                    } else if (blockRange > 500.0) {
                        guiGraphics.drawString(mc.font, (Component)Component.literal((String)"---m"), w / 2 - 6, h - 53, 0x66FF00, false);
                    } else {
                        guiGraphics.drawString(mc.font, (Component)Component.literal((String)FormatTool.format1D(blockRange, "m")), w / 2 - 6, h - 53, 0x66FF00, false);
                    }
                    mobileVehicle.renderFirstPersonOverlay(guiGraphics, mc.font, (Player)player, w, h, scale);
                    double heal = mobileVehicle.getHealth() / mobileVehicle.getMaxHealth();
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(100.0 * heal)), w / 2 - 165, h / 2 - 46, Mth.hsvToRgb((float)((float)heal / 3.7453184f), (float)1.0f, (float)1.0f), false);
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("SMOKE " + String.valueOf(mobileVehicle.getEntityData().get(MobileVehicleEntity.DECOY_COUNT)))), w / 2 - 165, h / 2 - 36, 0x66FF00, false);
                    VehicleHudOverlay.renderKillIndicator(guiGraphics, w, h);
                } else if (Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_BACK && !ClientEventHandler.zoomVehicle && (p = RenderHelper.worldToScreen(new Vec3(Mth.lerp((double)partialTick, (double)player.xo, (double)player.getX()), Mth.lerp((double)partialTick, (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)partialTick, (double)player.zo, (double)player.getZ())).add(iLand.getBarrelVec(partialTick).scale(192.0)), cameraPos)) != null) {
                    poseStack.pushPose();
                    float x = (float)p.x;
                    float y = (float)p.y;
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/drone.png"), x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                    VehicleHudOverlay.renderKillIndicator3P(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                    poseStack.pushPose();
                    poseStack.translate(x, y, 0.0f);
                    poseStack.scale(0.75f, 0.75f, 1.0f);
                    mobileVehicle.renderThirdPersonOverlay(guiGraphics, mc.font, (Player)player, w, h, scale);
                    double health = 1.0f - mobileVehicle.getHealth() / mobileVehicle.getMaxHealth();
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("HP " + FormatTool.format0D(100.0f * mobileVehicle.getHealth() / mobileVehicle.getMaxHealth()))), 30, 1, Mth.hsvToRgb((float)0.0f, (float)((float)health), (float)1.0f), false);
                    if (mobileVehicle.hasDecoy()) {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("SMOKE " + String.valueOf(mobileVehicle.getEntityData().get(MobileVehicleEntity.DECOY_COUNT)))), 30, 11, -1, false);
                    }
                    poseStack.popPose();
                    poseStack.popPose();
                }
                poseStack.popPose();
                return;
            }
        }
        scopeScale = 0.7f;
    }

    public static void renderKillIndicator(GuiGraphics guiGraphics, float w, float h) {
        float posX = w / 2.0f - 7.5f + (float)(2.0 * (Math.random() - 0.5));
        float posY = h / 2.0f - 7.5f + (float)(2.0 * (Math.random() - 0.5));
        float rate = (float)(40 - CrossHairOverlay.KILL_INDICATOR * 5) / 5.5f;
        if (CrossHairOverlay.HIT_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/hit_marker.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.VEHICLE_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/hit_marker_vehicle.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.HEAD_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/headshot_mark.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.KILL_INDICATOR > 0) {
            float posX1 = w / 2.0f - 7.5f - 2.0f + rate;
            float posY1 = h / 2.0f - 7.5f - 2.0f + rate;
            float posX2 = w / 2.0f - 7.5f + 2.0f - rate;
            float posY2 = h / 2.0f - 7.5f + 2.0f - rate;
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark1.png"), posX1, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark2.png"), posX2, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark3.png"), posX1, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark4.png"), posX2, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
    }

    public static void renderKillIndicator3P(GuiGraphics guiGraphics, float posX, float posY) {
        float rate = (float)(40 - CrossHairOverlay.KILL_INDICATOR * 5) / 5.5f;
        if (CrossHairOverlay.HIT_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/hit_marker.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.VEHICLE_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/hit_marker_vehicle.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.HEAD_INDICATOR > 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/headshot_mark.png"), posX, posY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (CrossHairOverlay.KILL_INDICATOR > 0) {
            float posX1 = posX - 2.0f + rate;
            float posY1 = posY - 2.0f + rate;
            float posX2 = posX + 2.0f - rate;
            float posY2 = posY + 2.0f - rate;
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark1.png"), posX1, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark2.png"), posX2, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark3.png"), posX1, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/kill_mark4.png"), posX2, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
    }

    private static void renderPassengerInfo(GuiGraphics guiGraphics, VehicleEntity vehicle, int w, int h) {
        List<Entity> passengers = vehicle.getOrderedPassengers();
        int index = 0;
        for (int i = passengers.size() - 1; i >= 0; --i) {
            Entity passenger = passengers.get(i);
            int y = h - 35 - index * 12;
            AtomicReference<String> name = new AtomicReference<String>("---");
            if (passenger != null) {
                name.set(passenger.getName().getString());
            }
            if (passenger instanceof Player) {
                Player player = (Player)passenger;
                CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(c -> c.findFirstCurio((Item)ModItems.DOG_TAG.get())).ifPresent(s -> name.set(s.stack().getHoverName().getString()));
            }
            guiGraphics.drawString(Minecraft.getInstance().font, name.get(), 42, y, 0x66FF00, true);
            String num = "[" + (i + 1) + "]";
            guiGraphics.drawString(Minecraft.getInstance().font, num, 25 - Minecraft.getInstance().font.width(num), y, 0x66FF00, true);
            RenderHelper.preciseBlit(guiGraphics, index == passengers.size() - 1 ? DRIVER : PASSENGER, 30.0f, y, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
            ++index;
        }
    }

    private static void renderWeaponInfo(GuiGraphics guiGraphics, VehicleEntity vehicle, int w, int h) {
        WeaponVehicleEntity weaponVehicle;
        LocalPlayer player = Minecraft.getInstance().player;
        if (!(vehicle instanceof WeaponVehicleEntity) || !(weaponVehicle = (WeaponVehicleEntity)((Object)vehicle)).banHand((Player)player)) {
            return;
        }
        boolean temp = wasRenderingWeapons;
        wasRenderingWeapons = false;
        assert (player != null);
        int index = vehicle.getSeatIndex((Entity)player);
        if (index == -1) {
            return;
        }
        List<VehicleWeapon> weapons = weaponVehicle.getAvailableWeapons(index);
        if (weapons.isEmpty()) {
            return;
        }
        int weaponIndex = weaponVehicle.getWeaponIndex(index);
        if (weaponIndex == -1) {
            return;
        }
        wasRenderingWeapons = temp;
        long currentTime = System.currentTimeMillis();
        if (!wasRenderingWeapons) {
            weaponSlotsTimer[weaponIndex].beginForward(currentTime);
            if (oldWeaponIndex != weaponIndex) {
                weaponSlotsTimer[oldWeaponIndex].endBackward(currentTime);
                oldWeaponIndex = weaponIndex;
                oldRenderWeaponIndex = weaponIndex;
            }
            weaponIndexUpdateTimer.beginForward(currentTime);
        }
        if (weaponIndex != oldWeaponIndex) {
            weaponSlotsTimer[weaponIndex].forward(currentTime);
            weaponSlotsTimer[oldWeaponIndex].backward(currentTime);
            oldRenderWeaponIndex = oldWeaponIndex;
            oldWeaponIndex = weaponIndex;
            weaponIndexUpdateTimer.beginForward(currentTime);
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int frameIndex = 0;
        for (int i = weapons.size() - 1; i >= 0 && i < 9; --i) {
            VehicleWeapon weapon = weapons.get(i);
            ResourceLocation frame = Mod.loc("textures/screens/vehicle_weapon/frame_" + (i + 1) + ".png");
            pose.pushPose();
            int maxXOffset = 35;
            AnimationTimer currentSlotTimer = weaponSlotsTimer[i];
            float progress = currentSlotTimer.getProgress(currentTime);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Mth.lerp((float)progress, (float)0.2f, (float)1.0f));
            float xOffset = Mth.lerp((float)progress, (float)maxXOffset, (float)0.0f);
            if (weaponIndex == i) {
                float startY = Mth.lerp((float)progress, (float)(h - (weapons.size() - 1 - oldRenderWeaponIndex) * 18 - 16), (float)(h - (weapons.size() - 1 - weaponIndex) * 18 - 16));
                RenderHelper.preciseBlit(guiGraphics, SELECTED, w - 95, startY, 100.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                if (InventoryTool.hasCreativeAmmoBox((Player)player) && !(weapon instanceof LaserWeapon) && !(weapon instanceof HeliRocketWeapon) && !(weapon instanceof SwarmDroneWeapon)) {
                    RenderHelper.preciseBlit(guiGraphics, NUMBER, (float)(w - 28) + xOffset, h - frameIndex * 18 - 15, 100.0f, 58.0f, 0.0f, 10.0f, 7.5f, 75.0f, 7.5f);
                } else {
                    VehicleHudOverlay.renderNumber(guiGraphics, weaponVehicle.getAmmoCount((Player)player), weapon instanceof LaserWeapon, (float)(w - 20) + xOffset, (float)(h - frameIndex * 18) - 15.5f, 0.25f);
                }
            }
            RenderHelper.preciseBlit(guiGraphics, frame, (float)(w - 85) + xOffset, h - frameIndex * 18 - 20, 100.0f, 0.0f, 0.0f, 75.0f, 16.0f, 75.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, weapon.icon, (float)(w - 85) + xOffset, h - frameIndex * 18 - 20, 100.0f, 0.0f, 0.0f, 75.0f, 16.0f, 75.0f, 16.0f);
            pose.popPose();
            ++frameIndex;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.popPose();
        if (oldWeaponIndex != oldRenderWeaponIndex && weaponIndexUpdateTimer.finished(currentTime)) {
            oldRenderWeaponIndex = oldWeaponIndex;
        }
        wasRenderingWeapons = true;
    }

    private static void renderNumber(GuiGraphics guiGraphics, int number, boolean percent, float x, float y, float scale) {
        float pX = x;
        if (percent) {
            RenderHelper.preciseBlit(guiGraphics, NUMBER, (pX -= 32.0f * scale) + 20.0f * scale, y, 100.0f, 200.0f * scale, 0.0f, 32.0f * scale, 30.0f * scale, 300.0f * scale, 30.0f * scale);
        }
        int index = 0;
        if (number == 0) {
            RenderHelper.preciseBlit(guiGraphics, NUMBER, pX, y, 100.0f, 0.0f, 0.0f, 20.0f * scale, 30.0f * scale, 300.0f * scale, 30.0f * scale);
        }
        while (number > 0) {
            int digit = number % 10;
            RenderHelper.preciseBlit(guiGraphics, NUMBER, pX - (float)(index * 20) * scale, y, 100.0f, (float)(digit * 20) * scale, 0.0f, 20.0f * scale, 30.0f * scale, 300.0f * scale, 30.0f * scale);
            number /= 10;
            ++index;
        }
    }
}

