/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.entity.vehicle.SpeedboatEntity;
import com.atsuishio.superbwarfare.entity.vehicle.Yx100Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.Serializable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class VehicleMgHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("vehicle_mg_hud");

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LandArmorEntity iLand;
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        PoseStack poseStack = guiGraphics.pose();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        if (!VehicleMgHudOverlay.shouldRenderCrossHair((Player)player)) {
            return;
        }
        Entity cannon = player.getVehicle();
        if (cannon == null) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Entity entity = player.getVehicle();
        if (entity instanceof LandArmorEntity && (iLand = (LandArmorEntity)entity) instanceof WeaponVehicleEntity) {
            MobileVehicleEntity mobileVehicle;
            WeaponVehicleEntity weaponVehicle = (WeaponVehicleEntity)((Object)iLand);
            if (iLand instanceof MobileVehicleEntity && weaponVehicle.hasWeapon((mobileVehicle = (MobileVehicleEntity)((Object)iLand)).getSeatIndex((Entity)player))) {
                Vec3 p;
                if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle) {
                    float fovAdjust = 70.0f / (float)((Integer)Minecraft.getInstance().options.fov().get()).intValue();
                    float f = Math.min((int)w, (int)h);
                    float f1 = Math.min((float)((float)w / f), (float)((float)h / f)) * fovAdjust;
                    int i = Mth.floor((float)(f * f1));
                    int j = Mth.floor((float)(f * f1));
                    int k = (w - i) / 2;
                    int l = (h - j) / 2;
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/cannon/cannon_crosshair_notzoom.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                    VehicleHudOverlay.renderKillIndicator(guiGraphics, w, h);
                } else if (Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_BACK && !ClientEventHandler.zoomVehicle && (p = RenderHelper.worldToScreen(new Vec3(Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)player.xo, (double)player.getX()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)player.zo, (double)player.getZ())).add(iLand.getGunVec(deltaTracker.getGameTimeDeltaPartialTick(true)).scale(192.0)), cameraPos)) != null) {
                    Entity heat2;
                    poseStack.pushPose();
                    float x = (float)p.x;
                    float y = (float)p.y;
                    poseStack.pushPose();
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/drone.png"), x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                    VehicleHudOverlay.renderKillIndicator3P(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                    poseStack.pushPose();
                    poseStack.translate(x, y, 0.0f);
                    poseStack.scale(0.75f, 0.75f, 1.0f);
                    Entity j = player.getVehicle();
                    if (j instanceof Yx100Entity) {
                        Yx100Entity yx100 = (Yx100Entity)j;
                        double heat2 = (float)((Integer)yx100.getEntityData().get(MobileVehicleEntity.HEAT)).intValue() / 100.0f;
                        guiGraphics.drawString(mc.font, (Component)Component.literal((String)(".50 HMG " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Player)player) ? "\u221e" : (Serializable)yx100.getEntityData().get(Yx100Entity.MG_AMMO)))), 30, -9, Mth.hsvToRgb((float)0.0f, (float)((float)heat2), (float)1.0f), false);
                    }
                    if ((heat2 = player.getVehicle()) instanceof SpeedboatEntity) {
                        SpeedboatEntity speedboat = (SpeedboatEntity)heat2;
                        double heat3 = (float)((Integer)speedboat.getEntityData().get(MobileVehicleEntity.HEAT)).intValue() / 100.0f;
                        guiGraphics.drawString(mc.font, (Component)Component.literal((String)(".50 HMG " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Player)player) ? "\u221e" : (Serializable)speedboat.getEntityData().get(MobileVehicleEntity.AMMO)))), 30, -9, Mth.hsvToRgb((float)0.0f, (float)((float)heat3), (float)1.0f), false);
                    }
                    double heal = 1.0f - mobileVehicle.getHealth() / mobileVehicle.getMaxHealth();
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("HP " + FormatTool.format0D(100.0f * mobileVehicle.getHealth() / mobileVehicle.getMaxHealth()))), 30, 1, Mth.hsvToRgb((float)0.0f, (float)((float)heal), (float)1.0f), false);
                    poseStack.popPose();
                    poseStack.popPose();
                    poseStack.popPose();
                }
            }
        }
    }

    private static boolean shouldRenderCrossHair(Player player) {
        Yx100Entity yx100;
        Entity entity;
        if (player == null) {
            return false;
        }
        return !player.isSpectator() && (player.getVehicle() instanceof SpeedboatEntity || (entity = player.getVehicle()) instanceof Yx100Entity && (yx100 = (Yx100Entity)entity).getNthEntity(1) == player);
    }
}

