/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer;

import com.atsuishio.superbwarfare.client.model.item.CustomGunModel;
import com.atsuishio.superbwarfare.client.renderer.ModRenderTypes;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.Color;
import software.bernie.geckolib.util.RenderUtil;

public class CustomGunRenderer<T extends GunItem>
extends GeoItemRenderer<T> {
    public static final float SCALE_RECIPROCAL = 0.0625f;
    protected T animatable;
    protected boolean renderArms = false;
    protected MultiBufferSource currentBuffer;
    protected RenderType renderType;
    public ItemDisplayContext transformType;

    public CustomGunRenderer(GeoModel<T> model) {
        super(model);
    }

    public void actuallyRender(PoseStack matrixStackIn, T animatable, BakedGeoModel model, RenderType type, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, boolean isRenderer, float partialTicks, int packedLightIn, int packedOverlayIn, int color) {
        this.currentBuffer = renderTypeBuffer;
        this.renderType = type;
        this.animatable = animatable;
        super.actuallyRender(matrixStackIn, animatable, model, type, renderTypeBuffer, vertexBuilder, isRenderer, partialTicks, packedLightIn, packedOverlayIn, color);
        if (this.renderArms) {
            this.renderArms = false;
        }
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }

    public ResourceLocation getTextureLocation(T animatable) {
        GeoModel geoModel = this.getGeoModel();
        if (this.renderPerspective != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && ((Boolean)DisplayConfig.ENABLE_GUN_LOD.get()).booleanValue() && geoModel instanceof CustomGunModel) {
            CustomGunModel gunModel = (CustomGunModel)geoModel;
            return gunModel.getLODTextureResource(animatable);
        }
        return geoModel.getTextureResource(animatable, null);
    }

    public void defaultRender(PoseStack poseStack, T animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        ResourceLocation modelLocation;
        poseStack.pushPose();
        Color renderColor = this.getRenderColor((GeoAnimatable)animatable, partialTick, packedLight);
        int packedOverlay = this.getPackedOverlay((GeoAnimatable)animatable, 0.0f, partialTick);
        GeoModel geoModel = this.getGeoModel();
        if (this.renderPerspective != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && ((Boolean)DisplayConfig.ENABLE_GUN_LOD.get()).booleanValue() && geoModel instanceof CustomGunModel) {
            CustomGunModel gunModel = (CustomGunModel)geoModel;
            modelLocation = gunModel.getLODModelResource(animatable);
        } else {
            modelLocation = geoModel.getModelResource(animatable, null);
        }
        BakedGeoModel model = geoModel.getBakedModel(modelLocation);
        if (renderType == null) {
            renderType = this.getRenderType(animatable, this.getTextureLocation(animatable), bufferSource, partialTick);
        }
        if (buffer == null) {
            buffer = bufferSource.getBuffer(renderType);
        }
        this.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor.argbInt());
        if (this.firePreRenderEvent(poseStack, model, bufferSource, partialTick, packedLight)) {
            this.preApplyRenderLayers(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, packedLight, packedLight, packedOverlay);
            this.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor.argbInt());
            this.renderIlluminatedBones(model, poseStack, bufferSource, animatable, renderType, buffer, partialTick, packedLight, packedOverlay, renderColor.argbInt());
            this.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, renderColor.argbInt());
            this.firePostRenderEvent(poseStack, model, bufferSource, partialTick, packedLight);
        }
        poseStack.popPose();
        this.renderFinal(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, renderColor.argbInt());
    }

    public void renderIlluminatedBones(BakedGeoModel model, PoseStack poseStack, MultiBufferSource bufferSource, T animatable, RenderType renderType, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        this.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, true, partialTick, packedLight, packedOverlay, color);
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        this.updateAnimatedTextureFrame((Item)animatable);
        for (GeoBone bone : model.topLevelBones()) {
            this.illuminatedRender(poseStack, animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, color);
        }
        this.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, true, partialTick, packedLight, packedOverlay, color);
        poseStack.popPose();
    }

    public void illuminatedRender(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.itemRenderTranslations));
        }
        poseStack.pushPose();
        RenderUtil.prepMatrixForBone((PoseStack)poseStack, (GeoBone)bone);
        if (bone.getName().endsWith("_illuminated")) {
            this.renderCubesOfBone(poseStack, bone, bufferSource.getBuffer(ModRenderTypes.ILLUMINATED.apply(this.getTextureLocation(animatable))), packedLight, OverlayTexture.NO_OVERLAY, color);
        }
        this.illuminatedRenderChildBones(poseStack, animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, color);
        poseStack.popPose();
    }

    public void illuminatedRenderChildBones(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (GeoBone childBone : bone.getChildBones()) {
            this.illuminatedRender(poseStack, animatable, childBone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay, color);
        }
    }
}

