/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.model.entity.DroneModel;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.MortarShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.RgoGrenadeEntity;
import com.atsuishio.superbwarfare.entity.projectile.RpgRocketEntity;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class DroneRenderer
extends GeoEntityRenderer<DroneEntity> {
    public DroneRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new DroneModel());
        this.shadowRadius = 0.2f;
    }

    public RenderType getRenderType(DroneEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void preRender(PoseStack poseStack, DroneEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float scale;
        this.scaleHeight = scale = 1.0f;
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public void render(DroneEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-entityIn.getYaw(partialTicks)));
        poseStack.mulPose(Axis.XP.rotationDegrees(entityIn.getBodyPitch(partialTicks)));
        poseStack.mulPose(Axis.ZP.rotationDegrees(entityIn.getRoll(partialTicks)));
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            ItemStack stack = player.getMainHandItem();
            CompoundTag tag = NBTTool.getTag(stack);
            DroneEntity drone = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"));
            if (!(stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked") && drone != null && drone.getUUID() == entityIn.getUUID())) {
                FastThrowableProjectile entity;
                if ((Integer)entityIn.getEntityData().get(DroneEntity.KAMIKAZE_MODE) == 1) {
                    entity = new MortarShellEntity((EntityType<? extends MortarShellEntity>)((EntityType)ModEntities.MORTAR_SHELL.get()), entityIn.level());
                    this.entityRenderDispatcher.render((Entity)entity, 0.0, 0.03, 0.25, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
                }
                if ((Integer)entityIn.getEntityData().get(DroneEntity.KAMIKAZE_MODE) == 3) {
                    entity = new RpgRocketEntity((EntityType<? extends RpgRocketEntity>)((EntityType)ModEntities.RPG_ROCKET.get()), entityIn.level());
                    this.entityRenderDispatcher.render((Entity)entity, 0.0, -0.03, -1.8, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
                }
                for (int i = 0; i < (Integer)entityIn.getEntityData().get(MobileVehicleEntity.AMMO); ++i) {
                    double yOffset = 0.0;
                    double xOffset = 0.0;
                    if (i == 0) {
                        yOffset = 0.2;
                        xOffset = 0.1;
                    }
                    if (i == 1) {
                        yOffset = 0.2;
                        xOffset = -0.1;
                    }
                    if (i == 2) {
                        yOffset = -0.05;
                        xOffset = 0.1;
                    }
                    if (i == 3) {
                        yOffset = -0.05;
                        xOffset = -0.1;
                    }
                    if (i == 4) {
                        yOffset = -0.3;
                        xOffset = 0.1;
                    }
                    if (i == 5) {
                        yOffset = -0.3;
                        xOffset = -0.1;
                    }
                    poseStack.pushPose();
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    poseStack.scale(0.35f, 0.35f, 0.35f);
                    RgoGrenadeEntity entity2 = new RgoGrenadeEntity((EntityType<? extends RgoGrenadeEntity>)((EntityType)ModEntities.RGO_GRENADE.get()), entityIn.level());
                    this.entityRenderDispatcher.render((Entity)entity2, xOffset, yOffset, 0.0, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
                    poseStack.popPose();
                }
            }
        }
        poseStack.popPose();
    }

    public void renderRecursively(PoseStack poseStack, DroneEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        String name = bone.getName();
        if (!animatable.onGround()) {
            if (name.equals("wingFL")) {
                bone.setRotY((float)(System.currentTimeMillis() % 36000000L) / 12.0f);
            }
            if (name.equals("wingFR")) {
                bone.setRotY((float)(System.currentTimeMillis() % 36000000L) / 12.0f);
            }
            if (name.equals("wingBL")) {
                bone.setRotY((float)(System.currentTimeMillis() % 36000000L) / 12.0f);
            }
            if (name.equals("wingBR")) {
                bone.setRotY((float)(System.currentTimeMillis() % 36000000L) / 12.0f);
            }
        }
        if (name.equals("c4")) {
            bone.setHidden((Integer)animatable.getEntityData().get(DroneEntity.KAMIKAZE_MODE) != 2);
        }
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }
}

