/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.layer.vehicle.PrismTankLaserLayer;
import com.atsuishio.superbwarfare.client.layer.vehicle.PrismTankLightLayer;
import com.atsuishio.superbwarfare.client.model.entity.PrismTankModel;
import com.atsuishio.superbwarfare.entity.vehicle.PrismTankEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class PrismTankRenderer
extends GeoEntityRenderer<PrismTankEntity> {
    public PrismTankRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new PrismTankModel());
        this.addRenderLayer(new PrismTankLaserLayer((GeoRenderer<PrismTankEntity>)this));
        this.addRenderLayer(new PrismTankLightLayer((GeoRenderer<PrismTankEntity>)this));
    }

    public RenderType getRenderType(PrismTankEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void preRender(PoseStack poseStack, PrismTankEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float scale;
        this.scaleHeight = scale = 1.0f;
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public void render(PrismTankEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot())));
        poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.prevRoll, (float)entityIn.getRoll())));
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        poseStack.popPose();
    }

    public void renderRecursively(PoseStack poseStack, PrismTankEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        int i;
        String name = bone.getName();
        Minecraft minecraft = Minecraft.getInstance();
        Frustum pCamera = minecraft.levelRenderer.getFrustum();
        AABB aabb = animatable.getBoundingBoxForCulling().inflate(3.0);
        if (aabb.hasNaN() || aabb.getSize() == 0.0) {
            aabb = new AABB(animatable.getX() - 5.0, animatable.getY() - 4.0, animatable.getZ() - 5.0, animatable.getX() + 5.0, animatable.getY() + 4.0, animatable.getZ() + 5.0);
        }
        if (name.equals("root")) {
            bone.setHidden(!pCamera.isVisible(aabb));
        }
        for (i = 0; i < 8; ++i) {
            if (name.equals("wheelL" + i)) {
                bone.setRotX(1.5f * Mth.lerp((float)partialTick, (float)animatable.leftWheelRotO, (float)animatable.getLeftWheelRot()));
            }
            if (!name.equals("wheelR" + i)) continue;
            bone.setRotX(1.5f * Mth.lerp((float)partialTick, (float)animatable.rightWheelRotO, (float)animatable.getRightWheelRot()));
        }
        if (name.equals("cannon") || name.equals("cannon2")) {
            bone.setRotY(Mth.lerp((float)partialTick, (float)animatable.turretYRotO, (float)animatable.getTurretYRot()) * ((float)Math.PI / 180));
        }
        if (name.equals("head")) {
            LocalPlayer player = Minecraft.getInstance().player;
            bone.setHidden(ClientEventHandler.zoomVehicle && animatable.getFirstPassenger() == player);
        }
        if (name.equals("laser")) {
            bone.setScaleZ(10.0f * ((Float)animatable.getEntityData().get(PrismTankEntity.LASER_LENGTH)).floatValue());
            float scale = Math.min(Mth.lerp((float)partialTick, (float)((Float)animatable.getEntityData().get(PrismTankEntity.LASER_SCALE_O)).floatValue(), (float)((Float)animatable.getEntityData().get(PrismTankEntity.LASER_SCALE)).floatValue()), 1.2f);
            bone.setScaleX(scale);
            bone.setScaleY(scale);
        }
        if (name.equals("L3") && animatable.getEnergy() > 0) {
            bone.setRotY((float)(System.currentTimeMillis() % 36000000L) / 75.0f);
        }
        if (name.equals("R3") && animatable.getEnergy() > 0) {
            bone.setRotY((float)(System.currentTimeMillis() % 36000000L) / 75.0f);
        }
        if (name.equals("barrel") || name.equals("barrel2")) {
            float a = animatable.getTurretYaw(partialTick);
            float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            bone.setRotX(-Mth.lerp((float)partialTick, (float)animatable.turretXRotO, (float)animatable.getTurretXRot()) * ((float)Math.PI / 180) - r * animatable.getPitch(partialTick) * ((float)Math.PI / 180) - r2 * animatable.getRoll(partialTick) * ((float)Math.PI / 180));
        }
        for (i = 0; i < 51; ++i) {
            float t2;
            float t;
            float tO = animatable.leftTrackO + (float)(2 * i);
            for (t = animatable.getLeftTrack() + (float)(2 * i); t >= 100.0f; t -= 100.0f) {
            }
            while (t <= 0.0f) {
                t += 100.0f;
            }
            while (tO >= 100.0f) {
                tO -= 100.0f;
            }
            while (tO <= 0.0f) {
                tO += 100.0f;
            }
            float tO2 = animatable.rightTrackO + (float)(2 * i);
            for (t2 = animatable.getRightTrack() + (float)(2 * i); t2 >= 100.0f; t2 -= 100.0f) {
            }
            while (t2 <= 0.0f) {
                t2 += 100.0f;
            }
            while (tO2 >= 100.0f) {
                tO2 -= 100.0f;
            }
            while (tO2 <= 0.0f) {
                tO2 += 100.0f;
            }
            if (name.equals("trackL" + i)) {
                bone.setPosY(Mth.lerp((float)partialTick, (float)this.getBoneMoveY(tO), (float)this.getBoneMoveY(t)));
                bone.setPosZ(Mth.lerp((float)partialTick, (float)this.getBoneMoveZ(tO), (float)this.getBoneMoveZ(t)));
            }
            if (name.equals("trackR" + i)) {
                bone.setPosY(Mth.lerp((float)partialTick, (float)this.getBoneMoveY(tO2), (float)this.getBoneMoveY(t2)));
                bone.setPosZ(Mth.lerp((float)partialTick, (float)this.getBoneMoveZ(tO2), (float)this.getBoneMoveZ(t2)));
            }
            if (name.equals("trackLRot" + i)) {
                bone.setRotX(-Mth.lerp((float)partialTick, (float)this.getBoneRotX(tO), (float)this.getBoneRotX(t)) * ((float)Math.PI / 180));
            }
            if (!name.equals("trackRRot" + i)) continue;
            bone.setRotX(-Mth.lerp((float)partialTick, (float)this.getBoneRotX(tO2), (float)this.getBoneRotX(t2)) * ((float)Math.PI / 180));
        }
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public float getBoneRotX(float t) {
        if ((double)t <= 37.6667) {
            return 0.0f;
        }
        if ((double)t <= 38.5833) {
            return Mth.lerp((float)((t - 37.6667f) / 0.9166031f), (float)0.0f, (float)-45.0f);
        }
        if ((double)t <= 39.75) {
            return -45.0f;
        }
        if ((double)t <= 40.6667) {
            return Mth.lerp((float)((t - 39.75f) / 0.91669846f), (float)-45.0f, (float)-90.0f);
        }
        if ((double)t <= 41.6667) {
            return -90.0f;
        }
        if ((double)t <= 42.5) {
            return -90.0f;
        }
        if ((double)t <= 43.5) {
            return Mth.lerp((float)(t - 42.5f), (float)-90.0f, (float)-135.0f);
        }
        if ((double)t <= 44.5833) {
            return -135.0f;
        }
        if ((double)t <= 45.0833) {
            return Mth.lerp((float)((t - 44.5833f) / 0.5f), (float)-135.0f, (float)-150.0f);
        }
        if ((double)t <= 52.25) {
            return -150.0f;
        }
        if ((double)t <= 52.75) {
            return Mth.lerp((float)((t - 52.25f) / 0.5f), (float)-150.0f, (float)-180.0f);
        }
        if ((double)t <= 84.3333) {
            return -180.0f;
        }
        if ((double)t <= 84.9167) {
            return Mth.lerp((float)((t - 84.3333f) / 0.58340454f), (float)-180.0f, (float)-210.0f);
        }
        if ((double)t <= 92.5833) {
            return -210.0f;
        }
        if ((double)t <= 93.4167) {
            return Mth.lerp((float)((t - 92.5833f) / 0.83340454f), (float)-210.0f, (float)-220.0f);
        }
        if ((double)t <= 94.25) {
            return -220.0f;
        }
        if ((double)t <= 94.9167) {
            return Mth.lerp((float)((t - 94.25f) / 0.6667023f), (float)-220.0f, (float)-243.33f);
        }
        if ((double)t <= 95.75) {
            return Mth.lerp((float)((t - 94.9167f) / 0.8332977f), (float)-243.33f, (float)-270.0f);
        }
        if ((double)t <= 96.8333) {
            return -270.0f;
        }
        if ((double)t <= 97.5833) {
            return Mth.lerp((float)((t - 96.8333f) / 0.75f), (float)-270.0f, (float)-315.0f);
        }
        if ((double)t <= 98.8333) {
            return -315.0f;
        }
        if ((double)t <= 99.5833) {
            return Mth.lerp((float)((t - 98.8333f) / 0.75f), (float)-315.0f, (float)-360.0f);
        }
        return 0.0f;
    }

    public float getBoneMoveY(float t) {
        if ((double)t <= 37.6667) {
            return 0.0f;
        }
        if ((double)t <= 38.5833) {
            return Mth.lerp((float)((t - 37.6667f) / 0.9166031f), (float)0.0f, (float)-1.8f);
        }
        if ((double)t <= 40.3333) {
            return Mth.lerp((float)((t - 38.5833f) / 1.75f), (float)-1.8f, (float)-4.1f);
        }
        if ((double)t <= 42.9167) {
            return Mth.lerp((float)((t - 40.3333f) / 2.583397f), (float)-4.1f, (float)-10.3f);
        }
        if ((double)t <= 44.25) {
            return Mth.lerp((float)((t - 42.9167f) / 1.3333015f), (float)-10.3f, (float)-12.9f);
        }
        if ((double)t <= 52.4167) {
            return Mth.lerp((float)((t - 44.25f) / 8.166698f), (float)-12.9f, (float)-23.96f);
        }
        if ((double)t <= 84.5833) {
            return -23.96f;
        }
        if (t <= 93.0f) {
            return Mth.lerp((float)((t - 84.5833f) / 8.416702f), (float)-23.96f, (float)-12.93f);
        }
        if ((double)t <= 95.25) {
            return Mth.lerp((float)((t - 93.0f) / 2.25f), (float)-12.93f, (float)-10.085f);
        }
        if ((double)t <= 97.5) {
            return Mth.lerp((float)((t - 95.25f) / 2.25f), (float)-10.085f, (float)-4.585f);
        }
        if ((double)t <= 98.8333) {
            return Mth.lerp((float)((t - 97.5f) / 1.3332977f), (float)-4.585f, (float)-1.165f);
        }
        if ((double)t <= 99.25) {
            return Mth.lerp((float)((t - 98.8333f) / 0.41670227f), (float)-1.165f, (float)-0.25f);
        }
        return Mth.lerp((float)((t - 99.25f) / 0.75f), (float)-0.25f, (float)0.0f);
    }

    public float getBoneMoveZ(float t) {
        if ((double)t <= 37.6667) {
            return Mth.lerp((float)(t / 37.6667f), (float)0.0f, (float)111.6f);
        }
        if ((double)t <= 38.5833) {
            return Mth.lerp((float)((t - 37.6667f) / 0.9166031f), (float)111.6f, (float)113.25f);
        }
        if ((double)t <= 40.3333) {
            return Mth.lerp((float)((t - 38.5833f) / 1.75f), (float)113.25f, (float)116.0f);
        }
        if ((double)t <= 42.9167) {
            return 116.0f;
        }
        if ((double)t <= 44.25) {
            return Mth.lerp((float)((t - 42.9167f) / 1.3333015f), (float)116.0f, (float)113.5f);
        }
        if ((double)t <= 52.4167) {
            return Mth.lerp((float)((t - 44.25f) / 8.166698f), (float)113.5f, (float)96.25f);
        }
        if ((double)t <= 84.5833) {
            return Mth.lerp((float)((t - 52.4167f) / 32.1666f), (float)96.25f, (float)14.095f);
        }
        if (t <= 93.0f) {
            return Mth.lerp((float)((t - 84.5833f) / 8.416702f), (float)14.095f, (float)-3.565f);
        }
        if ((double)t <= 95.25) {
            return Mth.lerp((float)((t - 93.0f) / 2.25f), (float)-3.565f, (float)-6.35f);
        }
        if ((double)t <= 97.5) {
            return Mth.lerp((float)((t - 95.25f) / 2.25f), (float)-6.35f, (float)-6.39f);
        }
        if ((double)t <= 98.8333) {
            return Mth.lerp((float)((t - 97.5f) / 1.3332977f), (float)-6.39f, (float)-3.03f);
        }
        if ((double)t <= 99.25) {
            return Mth.lerp((float)((t - 98.8333f) / 0.41670227f), (float)-3.03f, (float)-1.95f);
        }
        return Mth.lerp((float)((t - 99.25f) / 0.75f), (float)-1.95f, (float)0.0f);
    }
}

