/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.layer.vehicle.SpeedBoatHeatLayer;
import com.atsuishio.superbwarfare.client.layer.vehicle.SpeedBoatLayer;
import com.atsuishio.superbwarfare.client.layer.vehicle.SpeedBoatPowerLayer;
import com.atsuishio.superbwarfare.client.model.entity.SpeedboatModel;
import com.atsuishio.superbwarfare.entity.WaterMaskEntity;
import com.atsuishio.superbwarfare.entity.vehicle.SpeedboatEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class SpeedboatRenderer
extends GeoEntityRenderer<SpeedboatEntity> {
    public SpeedboatRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new SpeedboatModel());
        this.addRenderLayer(new SpeedBoatLayer((GeoRenderer<SpeedboatEntity>)this));
        this.addRenderLayer(new SpeedBoatPowerLayer((GeoRenderer<SpeedboatEntity>)this));
        this.addRenderLayer(new SpeedBoatHeatLayer((GeoRenderer<SpeedboatEntity>)this));
    }

    public RenderType getRenderType(SpeedboatEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void preRender(PoseStack poseStack, SpeedboatEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float scale;
        this.scaleHeight = scale = 1.0f;
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public void render(SpeedboatEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        Vec3 root = new Vec3(0.0, 0.9, 0.0);
        poseStack.rotateAround(Axis.YP.rotationDegrees(-entityYaw), (float)root.x, (float)root.y, (float)root.z);
        poseStack.rotateAround(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())), (float)root.x, (float)root.y, (float)root.z);
        poseStack.rotateAround(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.prevRoll, (float)entityIn.getRoll())), (float)root.x, (float)root.y, (float)root.z);
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        poseStack.pushPose();
        poseStack.scale(2.4f, 0.4f, 4.05f);
        poseStack.translate(0.0, 1.5, -0.22);
        WaterMaskEntity entity = new WaterMaskEntity((EntityType<WaterMaskEntity>)((EntityType)ModEntities.WATER_MASK.get()), entityIn.level());
        this.entityRenderDispatcher.render((Entity)entity, 0.0, 0.0, 0.0, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        poseStack.popPose();
        poseStack.popPose();
    }

    public void renderRecursively(PoseStack poseStack, SpeedboatEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float r2;
        float r;
        float a;
        String name = bone.getName();
        if (name.equals("root")) {
            a = ((Float)animatable.getEntityData().get(MobileVehicleEntity.YAW)).floatValue();
            r = (Mth.abs((float)a) - 90.0f) / 90.0f;
            bone.setPosZ(r * Mth.lerp((float)partialTick, (float)((float)animatable.recoilShakeO), (float)((float)animatable.getRecoilShake())) * 0.125f);
            bone.setRotX(r * Mth.lerp((float)partialTick, (float)((float)animatable.recoilShakeO), (float)((float)animatable.getRecoilShake())) * ((float)Math.PI / 180) * 0.5f);
            r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            bone.setPosX(r2 * Mth.lerp((float)partialTick, (float)((float)animatable.recoilShakeO), (float)((float)animatable.getRecoilShake())) * 0.125f);
            bone.setRotZ(r2 * Mth.lerp((float)partialTick, (float)((float)animatable.recoilShakeO), (float)((float)animatable.getRecoilShake())) * ((float)Math.PI / 180) * 0.75f);
        }
        if (name.equals("Rotor")) {
            bone.setRotZ(Mth.lerp((float)partialTick, (float)animatable.rotorRotO, (float)animatable.getRotorRot()));
        }
        if (name.equals("duo")) {
            bone.setRotY(Mth.lerp((float)partialTick, (float)animatable.rudderRotO, (float)animatable.getRudderRot()));
        }
        if (name.equals("paota")) {
            bone.setRotY(Mth.lerp((float)partialTick, (float)animatable.turretYRotO, (float)animatable.getTurretYRot()) * ((float)Math.PI / 180));
        }
        if (name.equals("gun")) {
            a = animatable.getTurretYaw(partialTick);
            r = (Mth.abs((float)a) - 90.0f) / 90.0f;
            r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            bone.setRotX(-Mth.lerp((float)partialTick, (float)animatable.turretXRotO, (float)animatable.getTurretXRot()) * ((float)Math.PI / 180) - r * animatable.getPitch(partialTick) * ((float)Math.PI / 180) - r2 * animatable.getRoll(partialTick) * ((float)Math.PI / 180));
        }
        if (name.equals("flare")) {
            bone.setRotZ((float)(0.5 * (Math.random() - 0.5)));
        }
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    protected float getDeathMaxRotation(SpeedboatEntity entityLivingBaseIn) {
        return 0.0f;
    }
}

