/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.model.entity.WheelChairModel;
import com.atsuishio.superbwarfare.entity.vehicle.WheelChairEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class WheelChairRenderer
extends GeoEntityRenderer<WheelChairEntity> {
    public WheelChairRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new WheelChairModel());
        this.shadowRadius = 0.5f;
    }

    public RenderType getRenderType(WheelChairEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void preRender(PoseStack poseStack, WheelChairEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float scale;
        this.scaleHeight = scale = 1.0f;
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public void render(WheelChairEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        Vec3 root = new Vec3(0.0, 0.4, 0.0);
        poseStack.rotateAround(Axis.YP.rotationDegrees(-entityYaw), (float)root.x, (float)root.y, (float)root.z);
        poseStack.rotateAround(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())), (float)root.x, (float)root.y, (float)root.z);
        poseStack.rotateAround(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.prevRoll, (float)entityIn.getRoll())), (float)root.x, (float)root.y, (float)root.z);
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        poseStack.popPose();
    }

    public void renderRecursively(PoseStack poseStack, WheelChairEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        String name = bone.getName();
        if (name.equals("w_rb")) {
            bone.setRotX(Mth.lerp((float)partialTick, (float)animatable.rightWheelRotO, (float)animatable.getRightWheelRot()));
        }
        if (name.equals("w_lb")) {
            bone.setRotX(Mth.lerp((float)partialTick, (float)animatable.leftWheelRotO, (float)animatable.getLeftWheelRot()));
        }
        if (name.equals("w_rr")) {
            bone.setRotX(4.0f * Mth.lerp((float)partialTick, (float)animatable.rightWheelRotO, (float)animatable.getRightWheelRot()));
        }
        if (name.equals("w_lr")) {
            bone.setRotX(4.0f * Mth.lerp((float)partialTick, (float)animatable.leftWheelRotO, (float)animatable.getLeftWheelRot()));
        }
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }
}

