/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.item.DogTag;
import com.atsuishio.superbwarfare.menu.DogTagEditorMenu;
import com.atsuishio.superbwarfare.network.message.send.DogTagFinishEditMessage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DogTagEditorScreen
extends AbstractContainerScreen<DogTagEditorMenu> {
    private static final ResourceLocation TEXTURE = Mod.loc("textures/gui/dog_tag_editor.png");
    public EditBox name;
    private short currentColor = 0;
    private short[][] icon = new short[16][16];
    public ItemStack stack;
    private boolean init = false;

    public DogTagEditorScreen(DogTagEditorMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.stack = pMenu.stack;
        this.imageWidth = 207;
        this.imageHeight = 185;
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        ItemStack stack = ((DogTagEditorMenu)this.menu).stack;
        pGuiGraphics.renderItem(stack, i + 18, j + 36);
        PoseStack pose = pGuiGraphics.pose();
        pose.pushPose();
        for (int x = 0; x < this.icon.length; ++x) {
            for (int y = 0; y < this.icon.length; ++y) {
                short num = this.icon[x][y];
                if (num == -1) continue;
                ChatFormatting color = ChatFormatting.getById((int)num);
                pGuiGraphics.fill(i + 66 + x * 9, j + 44 + y * 9, i + 58 + x * 9, j + 36 + y * 9, DogTagEditorScreen.getColorFromFormatting(color));
            }
        }
        pose.popPose();
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.name.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        this.drawColor(pMouseX, pMouseY, pButton);
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.drawColor(pMouseX, pMouseY, pButton);
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private void drawColor(double pMouseX, double pMouseY, int pButton) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        if (pMouseX >= (double)(i + 57) && pMouseX <= (double)(i + 201) && pMouseY >= (double)(j + 36) && pMouseY <= (double)(j + 179)) {
            double posX = pMouseX - (double)i - 57.0;
            double posY = pMouseY - (double)j - 36.0;
            if (Math.ceil(posX) % 9.0 == 0.0 || Math.ceil(posY) % 9.0 == 0.0) {
                return;
            }
            int x = (int)Math.floor(posX / 9.0);
            int y = (int)Math.floor(posY / 9.0);
            this.icon[Mth.clamp((int)x, (int)0, (int)15)][Mth.clamp((int)y, (int)0, (int)15)] = pButton == 0 ? (int)this.currentColor : -1;
        }
    }

    public void containerTick() {
        super.containerTick();
        if (!this.init) {
            if (!this.stack.isEmpty()) {
                this.name.setValue(this.stack.getHoverName().getString());
                this.icon = DogTag.getColors(this.stack);
            }
            this.init = true;
        }
    }

    protected void init() {
        super.init();
        this.subInit();
        this.clearColors();
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        for (short k = 0; k < 16; k = (short)(k + 1)) {
            ColorButton button = new ColorButton(k, i + 6 + k % 2 * 22, j + 62 + k / 2 * 10, 18, 8);
            this.addRenderableWidget((GuiEventListener)button);
        }
        ColorButton eraserButton = new ColorButton(-1, i + 17, j + 143, 18, 8);
        this.addRenderableWidget((GuiEventListener)eraserButton);
        FinishButton finishButton = new FinishButton(i + 6, j + 167, 40, 13);
        this.addRenderableWidget((GuiEventListener)finishButton);
    }

    protected void subInit() {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.name = new EditBox(this.font, i + 9, j + 11, 180, 12, (Component)Component.empty());
        this.name.setCanLoseFocus(false);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setBordered(false);
        this.name.setMaxLength(30);
        this.name.setResponder(this::onNameChanged);
        this.addWidget((GuiEventListener)this.name);
        this.setInitialFocus((GuiEventListener)this.name);
        this.name.setEditable(true);
    }

    private void onNameChanged(String name) {
        String s = name;
        ItemStack stack = ((DogTagEditorMenu)this.menu).stack;
        if (!stack.has(DataComponents.CUSTOM_NAME)) {
            s = "";
        }
        if (((DogTagEditorMenu)this.menu).setItemName(s) && this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.connection.send((Packet)new ServerboundRenameItemPacket(s));
        }
    }

    protected void renderLabels(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    public void clearColors() {
        for (short[] el : this.icon) {
            Arrays.fill(el, (short)-1);
        }
    }

    public static int getColorFromFormatting(ChatFormatting chatFormatting) {
        if (chatFormatting == null) {
            return -1;
        }
        return switch (chatFormatting) {
            case ChatFormatting.BLACK -> -16777216;
            case ChatFormatting.DARK_BLUE -> -16777046;
            case ChatFormatting.DARK_GREEN -> -16733696;
            case ChatFormatting.DARK_AQUA -> -16733526;
            case ChatFormatting.DARK_RED -> -5636096;
            case ChatFormatting.DARK_PURPLE -> -5635926;
            case ChatFormatting.GOLD -> -22016;
            case ChatFormatting.GRAY -> -5592406;
            case ChatFormatting.DARK_GRAY -> -11184811;
            case ChatFormatting.BLUE -> -11184641;
            case ChatFormatting.GREEN -> -11141291;
            case ChatFormatting.AQUA -> -11141121;
            case ChatFormatting.RED -> -43691;
            case ChatFormatting.LIGHT_PURPLE -> -43521;
            case ChatFormatting.YELLOW -> -171;
            case ChatFormatting.WHITE -> -1;
            default -> -1;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    class ColorButton
    extends AbstractButton {
        short color;

        public ColorButton(short color, int pX, int pY, int pWidth, int pHeight) {
            super(pX, pY, pWidth, pHeight, (Component)Component.empty());
            this.color = color;
        }

        public void onPress() {
            DogTagEditorScreen.this.currentColor = this.color;
            if (this.color == -1 && Screen.hasShiftDown()) {
                DogTagEditorScreen.this.clearColors();
            }
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }

        protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.isHovered || DogTagEditorScreen.this.currentColor == this.color) {
                if (this.color == -1) {
                    pGuiGraphics.blit(TEXTURE, this.getX(), this.getY(), 19.0f, 186.0f, 18, 8, 256, 256);
                } else {
                    pGuiGraphics.blit(TEXTURE, this.getX(), this.getY(), 0.0f, 186.0f, 18, 8, 256, 256);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class FinishButton
    extends AbstractButton {
        public FinishButton(int pX, int pY, int pWidth, int pHeight) {
            super(pX, pY, pWidth, pHeight, (Component)Component.empty());
        }

        public void onPress() {
            if (!DogTagEditorScreen.this.init) {
                return;
            }
            ArrayList<Short> colors = new ArrayList<Short>(DogTagEditorScreen.this.icon.length * DogTagEditorScreen.this.icon[0].length);
            short[][] sArray = DogTagEditorScreen.this.icon;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                short[] row;
                for (short color : row = sArray[i]) {
                    colors.add(color);
                }
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new DogTagFinishEditMessage(colors, DogTagEditorScreen.this.name.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.isHovered) {
                pGuiGraphics.blit(TEXTURE, this.getX(), this.getY(), 0.0f, 195.0f, 40, 13, 256, 256);
            }
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

