/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.sound;

import com.atsuishio.superbwarfare.client.sound.VehicleSoundInstance;
import com.atsuishio.superbwarfare.entity.vehicle.A10Entity;
import com.atsuishio.superbwarfare.entity.vehicle.Hpj11Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public abstract class VehicleFireSoundInstance
extends AbstractTickableSoundInstance {
    private final Minecraft client;
    private final Entity entity;
    private double lastDistance;
    private int fade = 0;
    private boolean die = false;

    public VehicleFireSoundInstance(SoundEvent sound, Minecraft client, Entity entity) {
        super(sound, SoundSource.AMBIENT, entity.getCommandSenderWorld().getRandom());
        this.client = client;
        this.entity = entity;
        this.looping = true;
        this.delay = 0;
    }

    protected abstract boolean canPlay(Entity var1);

    protected abstract float getPitch(Entity var1);

    protected abstract float getVolume(Entity var1);

    public void tick() {
        LocalPlayer player = this.client.player;
        if (this.entity.isRemoved() || player == null) {
            this.stop();
            return;
        }
        if (!this.canPlay(this.entity)) {
            this.die = true;
        }
        if (this.die) {
            if (this.fade > 0) {
                --this.fade;
            } else if (this.fade == 0) {
                this.stop();
                return;
            }
        } else if (this.fade < 3) {
            ++this.fade;
        }
        this.volume = this.getVolume(this.entity) * (float)this.fade;
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.z = this.entity.getZ();
        this.pitch = this.getPitch(this.entity);
    }

    public static class HPJ11CloseFireSound
    extends VehicleSoundInstance {
        public HPJ11CloseFireSound(MobileVehicleEntity mobileVehicle) {
            super((SoundEvent)ModSounds.HPJ_11_FIRE_3P.get(), Minecraft.getInstance(), mobileVehicle);
        }

        @Override
        protected boolean canPlay(MobileVehicleEntity mobileVehicle) {
            if (mobileVehicle instanceof Hpj11Entity) {
                Hpj11Entity hpj11Entity = (Hpj11Entity)mobileVehicle;
                return hpj11Entity.isFiring();
            }
            return false;
        }

        @Override
        protected float getPitch(MobileVehicleEntity mobileVehicle) {
            if (mobileVehicle instanceof Hpj11Entity) {
                Hpj11Entity hpj11Entity = (Hpj11Entity)mobileVehicle;
                return hpj11Entity.shootingPitch();
            }
            return 1.0f;
        }

        @Override
        protected float getVolume(MobileVehicleEntity mobileVehicle) {
            if (mobileVehicle instanceof Hpj11Entity) {
                Hpj11Entity hpj11Entity = (Hpj11Entity)mobileVehicle;
                return hpj11Entity.shootingVolume();
            }
            return 0.0f;
        }
    }

    public static class A10FireSound
    extends VehicleSoundInstance {
        public A10FireSound(MobileVehicleEntity mobileVehicle) {
            super((SoundEvent)ModSounds.A_10_FIRE.get(), Minecraft.getInstance(), mobileVehicle);
        }

        @Override
        protected boolean canPlay(MobileVehicleEntity mobileVehicle) {
            if (mobileVehicle instanceof A10Entity) {
                A10Entity a10Entity = (A10Entity)mobileVehicle;
                return a10Entity.isFiring();
            }
            return false;
        }

        @Override
        protected float getPitch(MobileVehicleEntity mobileVehicle) {
            if (mobileVehicle instanceof A10Entity) {
                A10Entity a10Entity = (A10Entity)mobileVehicle;
                return a10Entity.shootingPitch();
            }
            return 1.0f;
        }

        @Override
        protected float getVolume(MobileVehicleEntity mobileVehicle) {
            if (mobileVehicle instanceof A10Entity) {
                A10Entity a10Entity = (A10Entity)mobileVehicle;
                return a10Entity.shootingVolume();
            }
            return 0.0f;
        }
    }
}

