/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.compat.jade.providers;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.block.ContainerBlock;
import com.atsuishio.superbwarfare.block.entity.VehicleDeployerBlockEntity;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum VehicleDeployerProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation ID;

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        int h;
        Optional entityType = EntityType.byString((String)blockAccessor.getServerData().getString("EntityType"));
        if (entityType.isEmpty()) {
            return;
        }
        String registerName = EntityType.getKey((EntityType)((EntityType)entityType.get())).toString();
        String translationKey = ContainerBlock.getEntityTranslationKey(registerName);
        iTooltip.add((Component)Component.translatable((String)(translationKey == null ? "des.superbwarfare.container.empty" : translationKey)).withStyle(ChatFormatting.GRAY));
        int w = (int)(((EntityType)entityType.get()).getDimensions().width() + 1.0f);
        if (w % 2 == 0) {
            ++w;
        }
        if ((h = (int)(((EntityType)entityType.get()).getDimensions().height() + 1.0f)) != 0) {
            iTooltip.add((Component)Component.literal((String)(w + " x " + w + " x " + h)).withStyle(ChatFormatting.YELLOW));
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        VehicleDeployerBlockEntity blockEntity = (VehicleDeployerBlockEntity)blockAccessor.getBlockEntity();
        compoundTag.putString("EntityType", blockEntity.entityData.getString("EntityType"));
    }

    static {
        ID = Mod.loc("vehicle_deployer");
    }
}

