/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.DamageReduce;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.data.gun.ReloadType;
import com.atsuishio.superbwarfare.data.gun.subdata.Attachment;
import com.atsuishio.superbwarfare.data.gun.subdata.Bolt;
import com.atsuishio.superbwarfare.data.gun.subdata.Charge;
import com.atsuishio.superbwarfare.data.gun.subdata.Perks;
import com.atsuishio.superbwarfare.data.gun.subdata.Reload;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.data.gun.value.BooleanValue;
import com.atsuishio.superbwarfare.data.gun.value.DoubleValue;
import com.atsuishio.superbwarfare.data.gun.value.IntValue;
import com.atsuishio.superbwarfare.data.gun.value.ReloadState;
import com.atsuishio.superbwarfare.data.gun.value.StringEnumValue;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.GunsTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GunData {
    public final ItemStack stack;
    public final GunItem item;
    public final CompoundTag tag;
    public final CompoundTag data;
    public final CompoundTag perkTag;
    public final CompoundTag attachmentTag;
    public final String id;
    public static final LoadingCache<ItemStack, GunData> dataCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ItemStack, GunData>(){

        @NotNull
        public GunData load(@NotNull ItemStack stack) {
            return new GunData(stack);
        }
    });
    public final IntValue ammo;
    public final StringEnumValue<FireMode> fireMode;
    public final IntValue level;
    public final DoubleValue exp;
    public final DoubleValue upgradePoint;
    public final DoubleValue heat;
    public final BooleanValue overHeat;
    public final Reload reload;
    public final Charge charge;
    public final BooleanValue isEmpty;
    public final BooleanValue closeHammer;
    public final BooleanValue stopped;
    public final BooleanValue forceStop;
    public final IntValue loadIndex;
    public final BooleanValue holdOpen;
    public final BooleanValue hideBulletChain;
    public final BooleanValue draw;
    public final IntValue sensitivity;
    public final Bolt bolt;
    public final Attachment attachment;
    public final Perks perk;

    private GunData(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof GunItem)) {
            throw new IllegalArgumentException("stack is not GunItem!");
        }
        GunItem gunItem = (GunItem)item;
        this.item = gunItem;
        this.stack = stack;
        String id = stack.getDescriptionId();
        this.id = id.substring(id.indexOf(".") + 1).replace('.', ':');
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        this.tag = customData != null ? customData.copyTag() : new CompoundTag();
        this.data = this.getOrPut("GunData");
        this.perkTag = this.getOrPut("Perks");
        this.attachmentTag = this.getOrPut("Attachments");
        this.reload = new Reload(this);
        this.charge = new Charge(this);
        this.bolt = new Bolt(this);
        this.attachment = new Attachment(this);
        this.perk = new Perks(this);
        this.ammo = new IntValue(this.data, "Ammo");
        FireMode defaultFireMode = this.defaultGunData().defaultFireMode;
        if (defaultFireMode == null) {
            defaultFireMode = FireMode.SEMI;
        }
        this.fireMode = new StringEnumValue<FireMode>(this.data, "FireMode", defaultFireMode, FireMode::fromValue);
        this.level = new IntValue(this.data, "Level");
        this.exp = new DoubleValue(this.data, "Exp");
        this.upgradePoint = new DoubleValue(this.data, "UpgradePoint");
        this.isEmpty = new BooleanValue(this.data, "IsEmpty");
        this.closeHammer = new BooleanValue(this.data, "CloseHammer");
        this.stopped = new BooleanValue(this.data, "Stopped");
        this.forceStop = new BooleanValue(this.data, "ForceStop");
        this.loadIndex = new IntValue(this.data, "LoadIndex");
        this.holdOpen = new BooleanValue(this.data, "HoldOpen");
        this.hideBulletChain = new BooleanValue(this.data, "HideBulletChain");
        this.draw = new BooleanValue(this.data, "Draw");
        this.sensitivity = new IntValue(this.data, "Sensitivity");
        this.heat = new DoubleValue(this.data, "Heat");
        this.overHeat = new BooleanValue(this.data, "OverHeat");
    }

    private CompoundTag getOrPut(String name) {
        CompoundTag tag;
        if (!this.tag.contains(name)) {
            tag = new CompoundTag();
            this.tag.put(name, (Tag)tag);
        } else {
            tag = this.tag.getCompound(name);
        }
        return tag;
    }

    public boolean initialized() {
        return this.data.hasUUID("UUID");
    }

    public void initialize() {
        if (this.initialized()) {
            return;
        }
        this.data.putUUID("UUID", UUID.randomUUID());
        this.save();
    }

    public static GunData from(ItemStack stack) {
        return (GunData)dataCache.getUnchecked((Object)stack);
    }

    public GunItem item() {
        return this.item;
    }

    public ItemStack stack() {
        return this.stack;
    }

    public CompoundTag tag() {
        return this.tag;
    }

    public CompoundTag data() {
        return this.data;
    }

    public CompoundTag perk() {
        return this.perkTag;
    }

    public CompoundTag attachment() {
        return this.attachmentTag;
    }

    DefaultGunData defaultGunData() {
        return GunsTool.gunsData.getOrDefault(this.id, new DefaultGunData());
    }

    public double rawDamage() {
        return this.defaultGunData().damage;
    }

    public double perkDamageRate() {
        Perk perk = this.perk.get(Perk.Type.AMMO);
        if (perk instanceof AmmoPerk) {
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                return ammoPerk.damageRate * (float)this.rawProjectileAmount();
            }
            return ammoPerk.damageRate;
        }
        return 1.0;
    }

    public double damage() {
        return (this.rawDamage() + this.item.getCustomDamage(this.stack)) * this.perkDamageRate();
    }

    public double meleeDamage() {
        return this.defaultGunData().meleeDamage;
    }

    public int meleeDuration() {
        return Math.max(0, this.defaultGunData().meleeDuration);
    }

    public int meleeDamageTime() {
        return Math.min(this.meleeDuration(), this.defaultGunData().meleeDamageTime);
    }

    public double explosionDamage() {
        return this.defaultGunData().explosionDamage;
    }

    public double explosionRadius() {
        return this.defaultGunData().explosionRadius;
    }

    public double velocity() {
        return this.defaultGunData().velocity + this.item.getCustomVelocity(this.stack);
    }

    public double spread() {
        return this.defaultGunData().spread;
    }

    public int magazine() {
        return this.defaultGunData().magazine + this.item.getCustomMagazine(this.stack);
    }

    public boolean useBackpackAmmo() {
        return this.magazine() <= 0;
    }

    public ProjectileInfo projectileInfo() {
        ProjectileInfo info = this.defaultGunData().projectile;
        if (info == null) {
            return new ProjectileInfo();
        }
        return info;
    }

    public String projectileType() {
        return this.projectileInfo().type;
    }

    public int rawProjectileAmount() {
        return this.defaultGunData().projectileAmount;
    }

    public int projectileAmount() {
        Perk perk = this.perk.get(Perk.Type.AMMO);
        if (perk instanceof AmmoPerk) {
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                return 1;
            }
        }
        return this.defaultGunData().projectileAmount;
    }

    public double headshot() {
        return this.defaultGunData().headshot + this.item.getCustomHeadshot(this.stack);
    }

    public Set<ReloadType> reloadTypes() {
        if (this.defaultGunData().reloadTypes == null) {
            return Set.of();
        }
        return this.defaultGunData().reloadTypes;
    }

    public int defaultNormalReloadTime() {
        return this.defaultGunData().normalReloadTime;
    }

    public int defaultEmptyReloadTime() {
        return this.defaultGunData().emptyReloadTime;
    }

    public int defaultIterativeTime() {
        return this.defaultGunData().iterativeTime;
    }

    public int iterativeAmmoLoadTime() {
        return this.defaultGunData().iterativeAmmoLoadTime;
    }

    public int iterativeLoadAmount() {
        return this.defaultGunData().iterativeLoadAmount;
    }

    public int defaultPrepareTime() {
        return this.defaultGunData().prepareTime;
    }

    public int defaultPrepareLoadTime() {
        return this.defaultGunData().prepareLoadTime;
    }

    public int prepareAmmoLoadTime() {
        return this.defaultGunData().prepareAmmoLoadTime;
    }

    public int defaultPrepareEmptyTime() {
        return this.defaultGunData().prepareEmptyTime;
    }

    public int defaultFinishTime() {
        return this.defaultGunData().finishTime;
    }

    public int defaultActionTime() {
        return this.defaultGunData().boltActionTime + this.item.getCustomBoltActionTime(this.stack());
    }

    public double soundRadius() {
        return this.defaultGunData().soundRadius + this.item.getCustomSoundRadius(this.stack);
    }

    public double bypassArmor() {
        return this.defaultGunData().bypassArmor + this.item.getCustomBypassArmor(this.stack);
    }

    public double recoilX() {
        return this.defaultGunData().recoilX;
    }

    public double recoilY() {
        return this.defaultGunData().recoilY;
    }

    public double weight() {
        return this.defaultGunData().weight + this.customWeight();
    }

    public double customWeight() {
        return this.item.getCustomWeight(this.stack);
    }

    public double defaultZoom() {
        return this.defaultGunData().defaultZoom;
    }

    public double minZoom() {
        int scopeType = this.attachment.get(AttachmentType.SCOPE);
        return scopeType == 3 ? this.defaultGunData().minZoom : 1.25;
    }

    public double maxZoom() {
        int scopeType = this.attachment.get(AttachmentType.SCOPE);
        return scopeType == 3 ? this.defaultGunData().maxZoom : 114514.0;
    }

    public double zoom() {
        if (this.minZoom() == this.maxZoom()) {
            return this.defaultZoom();
        }
        return Mth.clamp((double)(this.defaultZoom() + this.item.getCustomZoom(this.stack)), (double)this.minZoom(), (double)this.maxZoom());
    }

    public int rpm() {
        return this.defaultGunData().rpm + this.item.getCustomRPM(this.stack);
    }

    public int burstAmount() {
        return this.defaultGunData().burstAmount;
    }

    public int shootDelay() {
        return this.defaultGunData().shootDelay;
    }

    public double heatPerShoot() {
        return this.defaultGunData().heatPerShoot;
    }

    public AmmoTypeInfo ammoTypeInfo() {
        String ammoType = this.defaultGunData().ammoType;
        if (ammoType == null || ammoType.isEmpty()) {
            return new AmmoTypeInfo(AmmoConsumeType.INVALID, "");
        }
        if (ammoType.startsWith("@")) {
            if (Ammo.getType(ammoType.substring(1)) == null) {
                return new AmmoTypeInfo(AmmoConsumeType.INVALID, ammoType.substring(1));
            }
            return new AmmoTypeInfo(AmmoConsumeType.PLAYER_AMMO, ammoType.substring(1));
        }
        if (ammoType.startsWith("#")) {
            if (ResourceLocation.tryParse((String)ammoType.substring(1)) == null) {
                return new AmmoTypeInfo(AmmoConsumeType.INVALID, ammoType.substring(1));
            }
            return new AmmoTypeInfo(AmmoConsumeType.TAG, ammoType.substring(1));
        }
        if (ResourceLocation.tryParse((String)ammoType) == null) {
            return new AmmoTypeInfo(AmmoConsumeType.INVALID, ammoType);
        }
        return new AmmoTypeInfo(AmmoConsumeType.ITEM, ammoType);
    }

    public boolean hasBackupAmmo(Player player) {
        return this.countBackupAmmo(player) > 0;
    }

    public int countBackupAmmo(Player player) {
        if (player.isCreative() || InventoryTool.hasCreativeAmmoBox(player)) {
            return Integer.MAX_VALUE;
        }
        AmmoTypeInfo info = this.ammoTypeInfo();
        return switch (info.type().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Ammo type = Ammo.getType(info.value());
                if (!$assertionsDisabled && type == null) {
                    throw new AssertionError();
                }
                yield type.get((Entity)player);
            }
            case 1 -> player.getInventory().clearOrCountMatchingItems(p -> p.getItem().toString().equals(info.value()), 0, (Container)player.inventoryMenu.getCraftSlots());
            case 2 -> player.getInventory().clearOrCountMatchingItems(p -> p.is(info.toTag()), 0, (Container)player.inventoryMenu.getCraftSlots());
            case 3 -> 0;
        };
    }

    public void consumeBackupAmmo(Player player, int count) {
        if (player.isCreative() || InventoryTool.hasCreativeAmmoBox(player) || count <= 0) {
            return;
        }
        AmmoTypeInfo info = this.ammoTypeInfo();
        switch (info.type().ordinal()) {
            case 0: {
                info.toPlayerAmmoType().set((Entity)player, info.toPlayerAmmoType().get((Entity)player) - count);
                break;
            }
            case 1: {
                player.getInventory().clearOrCountMatchingItems(p -> p.getItem().toString().equals(info.value()), count, (Container)player.inventoryMenu.getCraftSlots());
                break;
            }
            case 2: {
                player.getInventory().clearOrCountMatchingItems(p -> p.is(info.toTag()), count, (Container)player.inventoryMenu.getCraftSlots());
            }
        }
    }

    public boolean hasEnoughAmmoToShoot(Player player) {
        return this.useBackpackAmmo() ? this.hasBackupAmmo(player) : this.ammo.get() > 0;
    }

    public void reload(Player player) {
        this.reload(player, false);
    }

    public void reload(Player player, boolean extraOne) {
        if (this.useBackpackAmmo()) {
            return;
        }
        int mag = this.magazine();
        int ammo = this.ammo.get();
        int ammoNeeded = mag - ammo + (extraOne ? 1 : 0);
        if (ammo == 0 && this.defaultActionTime() > 0) {
            this.bolt.needed.set(false);
        }
        int available = this.countBackupAmmo(player);
        int ammoToAdd = Math.min(ammoNeeded, available);
        this.consumeBackupAmmo(player, ammoToAdd);
        this.ammo.set(ammo + ammoToAdd);
        this.reload.setState(ReloadState.NOT_RELOADING);
    }

    private static int getPriority(String s) {
        if (s == null || s.isEmpty()) {
            return 2;
        }
        if (s.startsWith("@")) {
            return 0;
        }
        if (s.startsWith("!")) {
            return 2;
        }
        return 1;
    }

    public List<Perk> availablePerks() {
        ArrayList<Perk> availablePerks = new ArrayList<Perk>();
        List<String> perkNames = this.defaultGunData().availablePerks;
        if (perkNames == null || perkNames.isEmpty()) {
            return availablePerks;
        }
        ArrayList<String> sortedNames = new ArrayList<String>(perkNames);
        sortedNames.sort((s1, s2) -> {
            int p2;
            int p1 = GunData.getPriority(s1);
            if (p1 != (p2 = GunData.getPriority(s2))) {
                return Integer.compare(p1, p2);
            }
            return s1.compareTo((String)s2);
        });
        ArrayList perks = new ArrayList();
        perks.addAll(ModPerks.AMMO_PERKS.getEntries());
        perks.addAll(ModPerks.DAMAGE_PERKS.getEntries());
        perks.addAll(ModPerks.FUNC_PERKS.getEntries());
        List<Perk> perkValues = perks.stream().map(DeferredHolder::get).toList();
        List<String> perkKeys = perks.stream().map(perk -> perk.getKey().location().toString()).toList();
        for (String name : sortedNames) {
            if (name.startsWith("@")) {
                String type;
                switch (type = name.substring(1)) {
                    case "Ammo": {
                        availablePerks.addAll(perkValues.stream().filter(perk -> perk.type == Perk.Type.AMMO).toList());
                        break;
                    }
                    case "Functional": {
                        availablePerks.addAll(perkValues.stream().filter(perk -> perk.type == Perk.Type.FUNCTIONAL).toList());
                        break;
                    }
                    case "Damage": {
                        availablePerks.addAll(perkValues.stream().filter(perk -> perk.type == Perk.Type.DAMAGE).toList());
                    }
                }
                continue;
            }
            if (name.startsWith("!")) {
                String n = name.substring(1);
                int index = perkKeys.indexOf(n);
                if (index != -1) {
                    availablePerks.remove(perkValues.get(index));
                    continue;
                }
                Mod.LOGGER.info("Perk {} not found", (Object)n);
                continue;
            }
            int index = perkKeys.indexOf(name);
            if (index != -1) {
                availablePerks.add(perkValues.get(index));
                continue;
            }
            Mod.LOGGER.info("Perk {} not found", (Object)name);
        }
        return availablePerks;
    }

    public boolean canApplyPerk(Perk perk) {
        return this.availablePerks().contains(perk);
    }

    public Set<FireMode> getAvailableFireModes() {
        if (this.defaultGunData().availableFireModes == null) {
            return Set.of();
        }
        return this.defaultGunData().availableFireModes;
    }

    public DamageReduce getRawDamageReduce() {
        return this.defaultGunData().damageReduce;
    }

    public double getRawDamageReduceRate() {
        return this.getRawDamageReduce().getRate();
    }

    public double getDamageReduceRate() {
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = this.perk.getInstance(type);
            if (instance == null) continue;
            return instance.perk().getModifiedDamageReduceRate(this.getRawDamageReduce());
        }
        return this.getRawDamageReduce().getRate();
    }

    public double getRawDamageReduceMinDistance() {
        return this.getRawDamageReduce().getMinDistance();
    }

    public double getDamageReduceMinDistance() {
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = this.perk.getInstance(type);
            if (instance == null) continue;
            return instance.perk().getModifiedDamageReduceMinDistance(this.getRawDamageReduce());
        }
        return this.getRawDamageReduce().getMinDistance();
    }

    public boolean canAdjustZoom() {
        return this.item.canAdjustZoom(this.stack);
    }

    public boolean canSwitchScope() {
        return this.item.canSwitchScope(this.stack);
    }

    public boolean reloading() {
        return this.reload.state() != ReloadState.NOT_RELOADING;
    }

    public boolean charging() {
        return this.charge.time() > 0;
    }

    public void save() {
        this.stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)this.tag));
    }

    public record AmmoTypeInfo(AmmoConsumeType type, String value) {
        @Nullable
        public Ammo playerAmmoType() {
            if (this.type != AmmoConsumeType.PLAYER_AMMO) {
                return null;
            }
            return this.toPlayerAmmoType();
        }

        @NotNull
        public Ammo toPlayerAmmoType() {
            if (this.type != AmmoConsumeType.PLAYER_AMMO) {
                throw new IllegalArgumentException("not PLAYER_AMMO type!");
            }
            return Objects.requireNonNull(Ammo.getType(this.value));
        }

        public TagKey<Item> toTag() {
            if (this.type != AmmoConsumeType.TAG) {
                throw new IllegalArgumentException("not TAG type!");
            }
            return ItemTags.create((ResourceLocation)ResourceLocation.parse((String)this.value()));
        }
    }

    public static enum AmmoConsumeType {
        PLAYER_AMMO,
        ITEM,
        TAG,
        INVALID;

    }
}

