/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun.value;

import net.minecraft.nbt.CompoundTag;

public class DoubleValue {
    private final CompoundTag tag;
    private final String name;
    private final double defaultValue;

    public DoubleValue(CompoundTag tag, String name, double defaultValue) {
        this.tag = tag;
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public DoubleValue(CompoundTag tag, String name) {
        this(tag, name, 0.0);
    }

    public double get() {
        if (this.tag.contains(this.name)) {
            return this.tag.getDouble(this.name);
        }
        return this.defaultValue;
    }

    public void set(double value) {
        if (value == this.defaultValue) {
            this.tag.remove(this.name);
        } else {
            this.tag.putDouble(this.name, value);
        }
    }

    public void reset() {
        this.set(this.defaultValue);
    }
}

