/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun.value;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;

public class StringEnumValue<T> {
    private final CompoundTag tag;
    private final String name;
    private final T defaultValue;
    private final Function<String, T> toEnum;

    public StringEnumValue(CompoundTag tag, String name, T defaultValue, Function<String, T> toEnum) {
        this.tag = tag;
        this.name = name;
        this.defaultValue = defaultValue;
        this.toEnum = toEnum;
    }

    public T get() {
        String value = this.tag.contains(this.name) ? this.tag.getString(this.name) : this.defaultValue.toString();
        return this.toEnum.apply(value);
    }

    public void set(T value) {
        if (value == this.defaultValue) {
            this.tag.remove(this.name);
        } else {
            this.tag.putString(this.name, value.toString());
        }
    }

    public void reset() {
        this.set(this.defaultValue);
    }
}

