/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.launchable;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.data.launchable.ShootData;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="superbwarfare")
public class LaunchableEntityTool {
    public static HashMap<String, JsonObject> launchableEntitiesData = new HashMap();

    public static void initJsonData(ResourceManager manager) {
        launchableEntitiesData.clear();
        for (Map.Entry entry : manager.listResources("launchable", file -> file.getPath().endsWith(".json")).entrySet()) {
            Resource attribute = (Resource)entry.getValue();
            try {
                Gson gson = new Gson();
                JsonObject data = (JsonObject)gson.fromJson((Reader)new InputStreamReader(attribute.open()), JsonObject.class);
                launchableEntitiesData.put(data.get("Type").getAsString(), data.get("Data").getAsJsonObject());
            }
            catch (Exception e) {
                Mod.LOGGER.error(e.getMessage());
            }
        }
    }

    @Nullable
    public static CompoundTag getModifiedTag(ProjectileInfo projectileInfo, ShootData data) {
        JsonObject launchableData;
        if (projectileInfo.data != null) {
            launchableData = projectileInfo.data;
        } else if (launchableEntitiesData.containsKey(projectileInfo.type)) {
            launchableData = launchableEntitiesData.get(projectileInfo.type);
        } else {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        for (Map.Entry d : launchableData.entrySet()) {
            Tag parsed = LaunchableEntityTool.parseData((JsonElement)d.getValue(), data);
            if (parsed == null) continue;
            tag.put((String)d.getKey(), parsed);
        }
        return tag;
    }

    @Nullable
    private static Tag parseData(JsonElement object, ShootData data) {
        if (object.isJsonObject()) {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry d : object.getAsJsonObject().entrySet()) {
                Tag parsed = LaunchableEntityTool.parseData((JsonElement)d.getValue(), data);
                if (parsed == null) continue;
                tag.put((String)d.getKey(), parsed);
            }
            return tag;
        }
        if (object.isJsonArray()) {
            ListTag tag = new ListTag();
            for (JsonElement d : object.getAsJsonArray()) {
                tag.add((Object)LaunchableEntityTool.parseData(d, data));
            }
            return tag;
        }
        if (object.isJsonPrimitive()) {
            JsonPrimitive prime = object.getAsJsonPrimitive();
            if (prime.isString()) {
                return LaunchableEntityTool.modifyStringTag(prime.getAsString(), data);
            }
            if (prime.isNumber()) {
                return DoubleTag.valueOf((double)prime.getAsLong());
            }
            if (prime.isBoolean()) {
                return ByteTag.valueOf((boolean)prime.getAsBoolean());
            }
            return null;
        }
        return null;
    }

    private static Tag modifyStringTag(String value, ShootData data) {
        return switch (value) {
            case "@sbw:damage" -> DoubleTag.valueOf((double)data.damage());
            case "@sbw:owner" -> NbtUtils.createUUID((UUID)data.shooter());
            case "@sbw:owner_string_lower" -> StringTag.valueOf((String)data.shooter().toString().replace("-", "").toLowerCase());
            case "@sbw:owner_string_upper" -> StringTag.valueOf((String)data.shooter().toString().replace("-", "").toUpperCase());
            case "@sbw:explosion_damage" -> DoubleTag.valueOf((double)data.explosionDamage());
            case "@sbw:explosion_radius" -> DoubleTag.valueOf((double)data.explosionRadius());
            case "@sbw:spread" -> DoubleTag.valueOf((double)data.spread());
            default -> StringTag.valueOf((String)value);
        };
    }

    @SubscribeEvent
    public static void serverStarted(ServerStartedEvent event) {
        LaunchableEntityTool.initJsonData(event.getServer().getResourceManager());
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        LaunchableEntityTool.initJsonData(event.getPlayerList().getServer().getResourceManager());
    }
}

