/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.datagen;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.datagen.ModAdvancementProvider;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ModAdvancement {
    public static final ResourceLocation MAIN_BACKGROUND = Mod.loc("textures/block/sandbag.png");
    public static final ResourceLocation LEGENDARY_BACKGROUND = Mod.loc("textures/block/steel_block.png");
    private final Advancement.Builder builder = Advancement.Builder.advancement();
    private ModAdvancement parent;
    public AdvancementHolder result;
    private final String id;
    private final Group group;

    public ModAdvancement(String id, UnaryOperator<Builder> b) {
        this.id = id;
        Builder builtInBuilder = new Builder();
        b.apply(builtInBuilder);
        this.group = builtInBuilder.group;
        Optional<Object> bg = Optional.empty();
        if (id.equals("root")) {
            if (this.group == Group.MAIN) {
                bg = Optional.of(MAIN_BACKGROUND);
            }
            if (this.group == Group.LEGENDARY) {
                bg = Optional.of(LEGENDARY_BACKGROUND);
            }
        }
        this.builder.display(new DisplayInfo(builtInBuilder.icon, this.titleComponent(), (Component)Component.translatable((String)this.description()), bg, builtInBuilder.type.frame, builtInBuilder.type.toast, builtInBuilder.type.announce, builtInBuilder.type.hide));
        ModAdvancementProvider.ADVANCEMENTS.add(this);
    }

    private String title() {
        return "superbwarfare.advancement." + this.group.path + "." + this.id;
    }

    private Component titleComponent() {
        if (this.group == Group.LEGENDARY && !this.id.equals("root")) {
            return Component.translatable((String)this.title()).withStyle(ChatFormatting.GOLD);
        }
        return Component.translatable((String)this.title());
    }

    private String description() {
        return this.title() + ".des";
    }

    public void save(Consumer<AdvancementHolder> t) {
        if (this.parent != null) {
            this.builder.parent(this.parent.result);
        }
        AdvancementHolder advancementholder = this.builder.build(Mod.loc(this.group.path + "/" + this.id));
        t.accept(advancementholder);
        this.result = advancementholder;
    }

    public class Builder {
        private Type type = Type.DEFAULT;
        private int keyIndex;
        private ItemStack icon;
        private Group group = Group.MAIN;

        Builder type(Type type) {
            this.type = type;
            return this;
        }

        Builder parent(ModAdvancement other) {
            ModAdvancement.this.parent = other;
            return this;
        }

        Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        Builder icon(ItemStack stack) {
            this.icon = stack;
            return this;
        }

        Builder whenBlockPlaced(Block block) {
            return this.externalTrigger(ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)block));
        }

        Builder whenIconCollected() {
            return this.externalTrigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{this.icon.getItem()}));
        }

        Builder whenItemCollected(ItemLike itemProvider) {
            return this.externalTrigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{itemProvider}));
        }

        Builder whenItemCollected(TagKey<Item> tag) {
            return this.externalTrigger(InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()}));
        }

        Builder whenItemConsumed(ItemLike itemProvider) {
            return this.externalTrigger(ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)itemProvider));
        }

        Builder whenIconConsumed() {
            return this.externalTrigger(ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)this.icon.getItem()));
        }

        Builder awardedForFree() {
            return this.externalTrigger(PlayerTrigger.TriggerInstance.tick());
        }

        Builder whenEffectChanged(MobEffectsPredicate.Builder predicate) {
            return this.externalTrigger(EffectsChangedTrigger.TriggerInstance.hasEffects((MobEffectsPredicate.Builder)predicate));
        }

        Builder externalTrigger(Criterion<?> trigger) {
            ModAdvancement.this.builder.addCriterion(String.valueOf(this.keyIndex), trigger);
            ++this.keyIndex;
            return this;
        }

        Builder requirement(AdvancementRequirements requirements) {
            ModAdvancement.this.builder.requirements(requirements);
            return this;
        }

        Builder group(Group group) {
            this.group = group;
            return this;
        }

        Builder rewardExp(int exp) {
            ModAdvancement.this.builder.rewards(AdvancementRewards.Builder.experience((int)exp).build());
            return this;
        }

        Builder rewardLootTable(ResourceLocation location) {
            ModAdvancement.this.builder.rewards(AdvancementRewards.Builder.loot((ResourceKey)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)location)).build());
            return this;
        }
    }

    static enum Group {
        MAIN("main"),
        LEGENDARY("legendary");

        public final String path;

        private Group(String path) {
            this.path = path;
        }
    }

    static enum Type {
        DEFAULT(AdvancementType.TASK, true, true, false),
        DEFAULT_NO_ANNOUNCE(AdvancementType.TASK, true, false, false),
        DEFAULT_CHALLENGE(AdvancementType.CHALLENGE, true, true, false),
        SILENT(AdvancementType.TASK, false, false, false),
        GOAL(AdvancementType.GOAL, true, true, false),
        SECRET(AdvancementType.TASK, true, true, true),
        SECRET_CHALLENGE(AdvancementType.CHALLENGE, true, true, true);

        private final AdvancementType frame;
        private final boolean toast;
        private final boolean announce;
        private final boolean hide;

        private Type(AdvancementType frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

