/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ClaymoreEntity
extends Entity
implements GeoEntity,
OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(ClaymoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.defineId(ClaymoreEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.defineId(ClaymoreEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ClaymoreEntity(EntityType<ClaymoreEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    public ClaymoreEntity(LivingEntity owner, Level level) {
        super((EntityType)ModEntities.CLAYMORE.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.getUUID());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UUID, Optional.empty()).define(LAST_ATTACKER_UUID, (Object)"undefined").define(HEALTH, (Object)Float.valueOf(10.0f));
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public boolean hurt(DamageSource source, float amount) {
        Level level;
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        if (source.is(ModDamageTypes.CUSTOM_EXPLOSION) || source.is(ModDamageTypes.MINE) || source.is(ModDamageTypes.PROJECTILE_BOOM)) {
            amount *= 0.2f;
        }
        if (source.getEntity() != null) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)source.getEntity().getStringUUID());
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), this.getX(), this.getY() + 0.2, this.getZ(), 2, 0.02, 0.02, 0.02, 0.1, false);
        }
        this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        this.entityData.set(HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(HEALTH)).floatValue() - amount));
        return super.hurt(source, amount);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.getOwner();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("Health", ((Float)this.entityData.get(HEALTH)).floatValue());
        compound.putString("LastAttacker", (String)this.entityData.get(LAST_ATTACKER_UUID));
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        if (compound.contains("Health")) {
            this.entityData.set(HEALTH, (Object)Float.valueOf(compound.getFloat("Health")));
        }
        if (compound.contains("LastAttacker")) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)compound.getString("LastAttacker"));
        }
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String s = compound.getString("Owner");
            assert (this.getServer() != null);
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.isOwnedBy((LivingEntity)player) && player.isShiftKeyDown()) {
            if (!this.level().isClientSide()) {
                this.discard();
            }
            if (!player.getAbilities().instabuild) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.CLAYMORE_MINE.get()));
            }
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        if (this.tickCount >= 12000 && !this.level().isClientSide()) {
            this.discard();
        }
        if (this.tickCount >= 40) {
            Vec3 center = new Vec3(x + 1.5 * this.getLookAngle().x, y + 1.5 * this.getLookAngle().y, z + 1.5 * this.getLookAngle().z);
            for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(1.25), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
                Player player;
                boolean condition = this.getOwner() != target && (target instanceof LivingEntity || target instanceof VehicleEntity) && !(target instanceof TargetEntity) && (!(target instanceof Player) || !(player = (Player)target).isCreative() && !player.isSpectator()) && (this.getOwner() != null && !this.getOwner().isAlliedTo(target) || target.getTeam() == null || target.getTeam().getName().equals("TDM")) && !target.isShiftKeyDown();
                if (!condition) continue;
                if (!level.isClientSide()) {
                    if (!this.level().isClientSide()) {
                        ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
                    }
                    this.discard();
                }
                Mod.queueServerWork(1, () -> {
                    if (!level.isClientSide()) {
                        this.triggerExplode();
                    }
                });
                break;
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
            f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        if (((Float)this.entityData.get(HEALTH)).floatValue() <= 0.0f) {
            this.destroy();
        }
        this.refreshDimensions();
    }

    public void destroy() {
        if (this.level() instanceof ServerLevel) {
            Entity attacker = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_ATTACKER_UUID));
            CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)(attacker == null ? this : attacker), ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), attacker == null ? this : attacker, attacker == null ? this : attacker), 25.0f, this.getX(), this.getY(), this.getZ(), 5.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
            this.discard();
        }
    }

    private void triggerExplode() {
        CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeMineDamage(this.level().registryAccess(), (Entity)this.getOwner()), 140.0f, this.getX(), this.getEyeY(), this.getZ(), 4.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose p_33597_) {
        return super.getDimensions(p_33597_).scale(0.5f);
    }

    public boolean isPushable() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

